% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_read_features.R
\name{ifcb_read_features}
\alias{ifcb_read_features}
\title{Read Feature Files from a Specified Folder or File Paths}
\usage{
ifcb_read_features(
  feature_files = NULL,
  multiblob = FALSE,
  feature_version = NULL,
  biovolume_only = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{feature_files}{A path to a folder containing feature files or a character vector of file paths.}

\item{multiblob}{Logical indicating whether to filter for multiblob files (default: FALSE).}

\item{feature_version}{Optional numeric or character version to filter feature files by (e.g. 2 for "_v2"). Default is NULL (no filtering).}

\item{biovolume_only}{Logical; if TRUE, only a minimal set of feature columns
required for biovolume calculations are read from each feature file
(typically \code{roi_number} and \code{biovolume}). This substantially reduces
memory usage and improves performance when other features are not needed.
If FALSE, all available feature columns are read.}

\item{verbose}{Logical. Whether to display progress information. Default is TRUE.}
}
\value{
A named list of data frames, where each element corresponds to a feature file read from \code{feature_files}.
The list is named with the base names of the feature files.
}
\description{
This function reads feature files from a given folder or a specified set of file paths,
optionally filtering them based on whether they are multiblob or single blob files.
}
\examples{
\dontrun{
# Read feature files from a folder
features <- ifcb_read_features("path/to/feature_folder")

# Read only multiblob feature files
multiblob_features <- ifcb_read_features("path/to/feature_folder", multiblob = TRUE)

# Read only version 4 feature files
v4_features <- ifcb_read_features("path/to/feature_folder", feature_version = 4)

# Read feature files from a list of file paths
features <- ifcb_read_features(c("path/to/file1.csv", "path/to/file2.csv"))
}

}
