% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_extract_annotated_images.R
\name{ifcb_extract_annotated_images}
\alias{ifcb_extract_annotated_images}
\title{Extract Annotated Images from IFCB Data}
\usage{
ifcb_extract_annotated_images(
  manual_folder,
  class2use_file,
  roi_folders,
  out_folder,
  skip_class = NA,
  verbose = TRUE,
  manual_recursive = FALSE,
  roi_recursive = TRUE,
  overwrite = FALSE,
  scale_bar_um = NULL,
  scale_micron_factor = 1/3.4,
  scale_bar_position = "bottomright",
  scale_bar_color = "black",
  old_adc = FALSE,
  use_python = FALSE,
  gamma = 1,
  add_trailing_numbers = TRUE,
  roi_folder = deprecated()
)
}
\arguments{
\item{manual_folder}{A character string specifying the path to the directory containing the manually classified .mat files.}

\item{class2use_file}{A character string specifying the path to the file containing class names.}

\item{roi_folders}{A character vector specifying one or more directories containing the ROI files.}

\item{out_folder}{A character string specifying the output directory where the extracted images will be saved.}

\item{skip_class}{A numeric vector of class IDs or a character vector of class names to be excluded from the count. Default is NULL.}

\item{verbose}{A logical value indicating whether to print progress messages. Default is TRUE.}

\item{manual_recursive}{Logical. If TRUE, the function will search for MATLAB files recursively within the \code{manual_folder}. Default is FALSE.}

\item{roi_recursive}{Logical. If TRUE, the function will search for data files recursively within the \code{roi_folder} (if provided). Default is TRUE.}

\item{overwrite}{A logical value indicating whether to overwrite existing PNG files. Default is FALSE.}

\item{scale_bar_um}{An optional numeric value specifying the length of the scale bar in micrometers. If NULL, no scale bar is added.}

\item{scale_micron_factor}{A numeric value defining the conversion factor from micrometers to pixels. Defaults to 1/3.4.}

\item{scale_bar_position}{A character string specifying the position of the scale bar in the image. Options are \code{"topright"}, \code{"topleft"}, \code{"bottomright"}, or \code{"bottomleft"}. Defaults to \code{"bottomright"}.}

\item{scale_bar_color}{A character string specifying the scale bar color. Options are \code{"black"} or \code{"white"}. Defaults to \code{"black"}.}

\item{old_adc}{A logical value indicating whether the \code{adc} file is of the old format (samples from IFCB1-6, labeled "IFCBxxx_YYYY_DDD_HHMMSS"). Default is FALSE.}

\item{use_python}{Logical. If \code{TRUE}, attempts to read the \code{.mat} file using a Python-based method. Default is \code{FALSE}.}

\item{gamma}{A numeric value for gamma correction applied to the image. Default is 1 (no correction). Values <1 increase contrast in dark regions, while values >1 decrease contrast.}

\item{add_trailing_numbers}{Logical. If \code{TRUE}, appends a zero-padded numeric suffix derived from the manual class index to the class name when naming output files. If \code{FALSE}, uses only the class name without a numeric suffix. Default is \code{TRUE}.}

\item{roi_folder}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{roi_folders} instead.}
}
\value{
None. The function saves the extracted PNG images to the specified output directory.
}
\description{
This function extracts labeled images from IFCB (Imaging FlowCytobot) data,
annotated using the MATLAB code from the \code{ifcb-analysis} repository (Sosik and Olson 2007).
It reads manually classified data, maps class indices to class names, and extracts
the corresponding Region of Interest (ROI) images, saving them to the specified directory.
}
\details{
If \code{use_python = TRUE}, the function tries to read the \code{.mat} file using \code{ifcb_read_mat()}, which relies on \code{SciPy}.
This approach may be faster than the default approach using \code{R.matlab::readMat()}, especially for large \code{.mat} files.
To enable this functionality, ensure Python is properly configured with the required dependencies.
You can initialize the Python environment and install necessary packages using \code{ifcb_py_install()}.

If \code{use_python = FALSE} or if \code{SciPy} is not available, the function falls back to using \code{R.matlab::readMat()}.
}
\examples{
\dontrun{
ifcb_extract_annotated_images(
  manual_folder = "path/to/manual_folder",
  class2use_file = "path/to/class2use_file.mat",
  roi_folders = "path/to/roi_folder",
  out_folder = "path/to/out_folder",
  skip_class = 1 # Skip "unclassified"
)
}
}
\references{
Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
\seealso{
\code{\link{ifcb_extract_pngs}} \code{\link{ifcb_extract_classified_images}} \url{https://github.com/hsosik/ifcb-analysis}
}
