% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWAS_BT.R
\name{GWAS_BT}
\alias{GWAS_BT}
\title{GWAS_BT function}
\usage{
GWAS_BT(plink_path, b_file, discovery_pheno, discovery_cov, thread = 20)
}
\arguments{
\item{plink_path}{Path to the PLINK executable application}

\item{b_file}{Prefix of the binary files, where all .fam, .bed and .bim files have a common prefix}

\item{discovery_pheno}{Name (with file extension) of the phenotype file containing family ID, individual
ID and phenotype of the discovery dataset as columns, without heading}

\item{discovery_cov}{Name (with file extension) of the covariate file containing family ID, individual
ID, and covariate(s) of the discovery dataset as columns, without heading. If no covariate is
used, have a constant column (e.g. vector of 1s)}

\item{thread}{Number of threads used (default = 20)}
}
\value{
A data frame with two columns:
\describe{
\item{beta}{Estimated effect size (log odds) for each SNP.}
\item{se}{Standard error of the estimated effect size.}
}
}
\description{
Performs genome-wide association study (GWAS) using plink2 logistic model and outputs
the GWAS summary statistics with additive SNP effects (beta) and
standard errors (se)
}
\details{
The function uses logistic regression to regress the binary phenotype (1/2 coding for controls/cases)
on each SNP separately using plink 2. Then the estimated effects and standard errors are adjusted
for standardization. It is optional to employ covariates in the model. If no covariate is used,
create your covariate file with a constant in the 3rd column (e.g. vector of 1s).
}
\examples{
\dontrun{
  results <- GWAS_BT(
    plink_path = "./plink2",
    b_file = "./binary_file_prefix",
    discovery_pheno = "./discovery_phenotype_file",
    discovery_cov = "./discovery_covariate_file",
    thread = 48
  )
  head(gwas_results)
}

}
