% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_v.R, R/bc.R, R/dhondt.R, R/droop.R,
%   R/fortified_pr.R, R/hagenbachbischoff.R, R/hare.R, R/imperiali.R,
%   R/lim_nom.R, R/modsaintelague.R, R/plurality.R, R/saintelague.R, R/stv.R
\name{ElecFuns}
\alias{ElecFuns}
\alias{a_v}
\alias{bc}
\alias{dhondt}
\alias{droop}
\alias{fortified_pr}
\alias{hagenbachbischoff}
\alias{hare}
\alias{imperiali}
\alias{lim_nom}
\alias{modsaintelague}
\alias{plurality}
\alias{saintelague}
\alias{stv}
\title{Electoral Functions}
\usage{
a_v(v, ...)

bc(v, m, mod = TRUE, n_cand_bc, ...)

dhondt(v, m, threshold = 0, ...)

droop(v, m, threshold = 0, ...)

fortified_pr(
  v,
  m,
  threshold = 0,
  fpr_cutoff,
  pr_formula,
  include_first_party,
  ...
)

hagenbachbischoff(v, m, threshold = 0, ...)

hare(v, m, threshold = 0, ...)

imperiali(v, m, threshold = 0, ...)

lim_nom(v, m, ...)

modsaintelague(v, m, threshold = 0, ...)

plurality(v, m, ...)

saintelague(v, m, threshold = 0, ...)

stv(v, m, ...)
}
\arguments{
\item{v}{Matrix with candidates/parties (the interpretation depends
on the function) in the columns. Each cell has the number of votes cast for
each candidate/party. For AV and STV, the matrix should have ranked votes,
with each rank in a separate row.}

\item{...}{Additional optional arguments (currently ignored).}

\item{m}{Number of seats to be awarded.}

\item{mod}{Included in the BC function. If TRUE, makes the sequence run
from 1 to the number of votes and inverses it;
if FALSE, the sequence run from the number of votes to 1). Should be TRUE
if the intention is to use the BC system described in the details.}

\item{n_cand_bc}{Number of candidates in the Borda Count system. This is only
used for the Borda Count system.}

\item{threshold}{Proportion of votes that a party (or candidate) needs to
surpass in order to be eligible to receive seats.}

\item{fpr_cutoff}{Included in the fortified_pr function. It is a percentage
of votes that a party needs to surpass in order to be eligible to receive the
"bonus" seats assigned to the winner of the election.}

\item{pr_formula}{A character vector that specifies the quota implemented.
In general, is equal to "hare". The Hare quota is the number of votes cast
in a district divided by M.}

\item{include_first_party}{A logical value that indicates whether the
top-voted list party participate in the distribution of the remaining seats
or not. If TRUE, it does.}
}
\value{
For Alternative Vote, the name of the candidate that obtains majority support.

For Borda count and all PR formulas, a vector of seats awarded to each candidate.

For plurality, a matrix with all candidates participating (1 if a seat was awarded, 0
if not). If m = 1, candidates can be interpreted as parties.
}
\description{
This file contains details and examples of the electoral functions (electoral formulas) implemented in the i3pack package.
}
\section{Details}{
 The a_v function is used in single member districts and lets
voters rank the candidates competing in the district from most to least preferred.
If a candidate is ranked first by a majority of voters, he or she
wins the single seat available. If no candidate obtains a majority of votes, the
candidate with the fewest first-place votes is eliminated and her votes are
distributed to the candidates that her supporters ranked second. If this redistribution
gives another candidate a majority of the votes, that candidate is elected; if not, the
second weakest candidate is eliminated and his votes are redistributed among the
surviving candidates. This process of redistribution and recounting continues
until a candidate obtains majority support.

 The bc function is used in single-member or multi-member
districts, though it is typically discussed in settings that return a single
choice. Voters assign candidates a rank, but seats are then awarded by
plurality rather than majority. Each rank is assigned a weight, and a
candidate’s vote total is the sum of the full and fractional votes he or she
receives. For example, a first place rank might be weighted by one, a second
place rank by 1/2, a third place rank by 1/3. A candidate ranked first by one
hundred voters, second by twenty voters, and third by ten voters would be
awarded a total of 100/1 + 20/2 + 12/3 =114 votes. This, in fact, is the
modified bc system used to elect the Parliament in the country of Nauru
(not included in our dataset), an island in Micronesia. To our knowledge,
the bc is not used in national elections elsewhere.

 The dhondt function divides parties’ vote totals
successively by 1, 2, 3, 4, 5, and so on (until m). Seats are then awarded
sequentially starting with the party that enjoys the largest quotient
until no more seats are available.

 The droop function assigns seats by calculating the Droop
quota, which is Q = V/(M+1) + 1 (rounded to the nearest integer). The seats
are assigned in two stages. First, the number of votes obtained by each
party is divided by Q and rounded down. That integer is the number of seats
that the party will obtain in the first stage. Second, Q is multiplied by
the number of seats obtained by each party (Si) and that number if
substracted from the total number of votes obtained by that party. That would
be a residual: Ri = Vi - Q*Si. The remaining seats are assigned to the
parties with the largest residuals.

 The fortified_pr function is used for proportional
representation with a majority bonus. The seat allocation formula is
different from other list PR systems. Under this set of rules, the list which
receives the largest vote share receives a bonus in seats. Sometimes, that
list needs to surpass a certain percentage of votes (the cutoff) in order to
be eligible for that. In this case, the function assigns half the seats to
the party with most votes and assigns the other half of the seats
proportionally.

 The hagenbachbischoff function works with the same
procedure as the droop function, but in this case Q = V/(M+1).

 The hare function works with the same procedure as the
droop function, but in this case Q = V/M.

 The imperiali function works with the same procedure as
the droop function, but in this case Q = V/(M+2).

 The lim_nom function is used to calculate the seats obtained
with closed-list plurality with limited nomination system. Voters only get
one vote, which is cast for a closed party list. District magnitude needs
to be 3 (i.e., M=3) and the top vote-getting party is awarded two seats
while the third seat goes to the second-place finisher — even if its level
of support is abysmally low.

 The modsaintelague function works with the same procedure as
the dhondt function, but in this case the sequence of numbers used for the
division is only comprised by odd numbers except for the first one, which is
1.4 instead of 1. It ends up being: 1.4, 3, 5, 7 and so on. It uses an amount
of numbers equal to m.

 The plurality function returns the number of seats according
to the seat allocation formula—plurality. In a single-member district decided
by plurality system, voters get a single vote, cast at the party level, to
fill the only contested seat, and that seat goes to the top vote-earner
regardless of level of support. In a multiple non-transferable vote system,
the votes are cast at the candidate level and m is greater than 1. The number
of candidates should always be greater or equal to m.

 The saintelague function works with the same procedure as
the dhondt function, but in this case the sequence of numbers used for the
division is only comprised by odd numbers (1, 3, 5, 7 and so on). It uses an
amount of odd numbers equal to m.
}

\examples{

a_v(v=ranked)
 
 
                     
bc(v=ranked, 2, mod=TRUE, n_cand_bc=3)

## D'hondt without threshold: 

dhondt(v=example, m=3)

## D'hondt with 30\% threshold: 

dhondt(v=example, m=3, threshold=0.3) 

## Droop without threshold: 

droop(v=example, m=3)

## Droop with 20\% threshold: 

droop(v=example, m=3, threshold=0.2) 

## Fortified PR without cutoff: 

fortified_pr(v=example, m=4, fpr_cutoff=0, include_first_party=TRUE, pr_formula="hare")

## Fortified PR with a 50\% cutoff (including first party): 

fortified_pr(v=example, m=4, fpr_cutoff=0.5, include_first_party=TRUE, pr_formula="hare")

## Fortified PR with a 50\% cutoff (without including first party): 

fortified_pr(v=example, m=4, fpr_cutoff=0.5, include_first_party=FALSE, pr_formula="hare")

## Hagenbach-Bischoff without threshold: 

hagenbachbischoff(v=example, m=3)

## Hagenbach-Bischoff with 20\% threshold: 

hagenbachbischoff(v=example, m=3, threshold=0.2) 

## Hare without threshold

hare (v=example, m=3)

## Hare with 20\% threshold

hare (v=example, m=3, threshold=0.2)

## Imperiali without threshold: 

imperiali(v=example, m=3)

## Imperiali with 20\% threshold: 

imperiali(v=example, m=3, threshold=0.2) 


## Lim_nom (only works with m=3)

lim_nom(v=example, m=3)

## Modified Sainte-Lague without threshold: 

modsaintelague(v=example, m=3)
 
## Modified Sainte-Lague with 20\% threshold: 

modsaintelague(v=example, m=3, threshold=0.2) 

plurality (v=example, m=3)
## Sainte-Lague without threshold: 

saintelague(v=example, m=3)

## Sainte-Lague with 20\% threshold: 

saintelague(v=example, m=3, threshold=0.2) 


stv (v=ranked, m=2)
}
