% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_node}
\alias{get_node}
\title{Get Line Node}
\usage{
get_node(x, position = "end")
}
\arguments{
\item{x}{sf sf data.frame with one or more LINESTRING features}

\item{position}{character either "start" or "end"}
}
\value{
sf data.frame containing requested nodes
}
\description{
Given one or more lines, returns a particular node from
the line.
}
\examples{

x <- sf::read_sf(system.file("extdata/new_hope.gpkg", package = "hydroloom"))

start <- get_node(x, "start")
end <- get_node(x, "end")

plot(sf::st_zm(sf::st_geometry(x)),
  lwd = x$StreamOrde, col = "blue")
plot(sf::st_geometry(start), add = TRUE)

plot(sf::st_zm(sf::st_geometry(x)),
  lwd = x$StreamOrde, col = "blue")
plot(sf::st_geometry(end), add = TRUE)

}
