% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/River_Engineering.R
\name{block_size}
\alias{block_size}
\title{Calculate dimensions of rip rap block size}
\usage{
block_size(h, h_z, J, gamma, psi, geo = NULL, S = 1.15, Theta_c = 0.047,
  s = 2.65, ret = "all")
}
\arguments{
\item{h}{Numeric. Global maximum water table level above riverbed [m].}

\item{h_z}{Numeric. Local water table level above the regarded block [m].}

\item{J}{Numeric. Bottom slope [-].}

\item{gamma}{Numeric or NULL. Angle of bank slope [degrees]. Use NULL if
specifying \code{geo}.}

\item{psi}{Numeric. Inner friction angle [degrees]. Values between 50 and 55
are recommended (Bezzola 2012).}

\item{geo}{Numeric vector of length 2 or NULL. Slope geometry as a triangle:
c(vertical length, horizontal length) [-]. If given, \code{gamma} is ignored.}

\item{S}{Numeric. Safety factor, default is 1.15 [-].}

\item{Theta_c}{Numeric. Shear stress parameter, default is 0.047 [-].}

\item{s}{Numeric. Relative density of blocks, default is 2.65 [-].}

\item{ret}{Character. Result to return: \code{"all"} (default), \code{"D"}, or \code{"b"}.}
}
\value{
If \code{ret = "all"}, returns a list with:
\item{D}{Diameter of block [m]}
\item{m}{Mass of block [kg]}
\item{a}{a-axis length [m]}
\item{b}{b-axis length [m]}
\item{c}{c-axis length [m]}

Otherwise returns the requested single value:
\itemize{
 \item \code{"D"} Diameter of block [m]
 \item \code{"b"} b-axis length [m]
}
}
\description{
Calculates the dimensions and mass of a rip rap block based on slope
geometry, water table levels, and material properties.
}
\examples{
# Calculate block size at bottom of slope with given slope angle
block_size(h = 5, h_z = 5, J = 0.0015, gamma = 33.69, psi = 50)

# Calculate block size with slope geometries 2:3
block_size(h = 5, h_z = 5, J = 0.0015, gamma = NULL, psi = 50, geo = c(2, 3))

# Calculate block size at middle of slope with slope geometries 2:3
block_size(h = 5, h_z = 2.5, J = 0.0015, gamma = NULL, psi = 50, geo = c(2, 3))
}
\references{
Bezzola (2012). Flussbau, Vorlesungsmanuskript, ETH Zuerich
}
