% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_HM.R
\name{plot}
\alias{plot}
\alias{plot.HM}
\title{Summary plots for hybrid Models}
\usage{
\method{plot}{HM}(x, sim = 1, plot.type = "subpop", facet.scales = "free_y", ...)
}
\arguments{
\item{x}{\code{HM} object}

\item{sim}{indicates which simulation to plot.}

\item{plot.type}{plots the mean number of each state variable for the whole
population ('pop.mean'), or the subpopulations of a particular
simulation ('subpop', default value), or the mean of each subpopulation
('subpop.mean').}

\item{facet.scales}{should scales be fixed ("free_y", the default), free ("free"), or free
in one dimension ("free_x", "free_y"). See ggplot2 package for more
details.}

\item{...}{arguments to be passed to methods.}
}
\description{
\code{plot.HM} is a method to plot hybrid models from this
              package
}
\examples{
# Parameters and initial conditions for an SIS model
# loading the data set 
data(networkSample) # help("networkSample"), for more info
networkSample <- networkSample[which(networkSample$Day < "2012-03-20"),]

var.names <- list(from = 'originID', to = 'destinationID', Time = 'Day',
                  arc = 'num.animals')
                  
prop.func <- c('beta * S * I / (S + I)', 'gamma * I')
state.var <- c('S', 'I')
state.change.matrix <- matrix(c(-1,  1,  # S
                                 1, -1), # I
                              nrow = 2, ncol = 2, byrow = TRUE)
                              
model.parms <- c(beta = 0.1, gamma = 0.01)

init.cond <- rep(100, length(unique(c(networkSample$originID,
                                      networkSample$destinationID))))
names(init.cond) <- paste('S', unique(c(networkSample$originID,
                                        networkSample$destinationID)), sep = '')
init.cond <- c(init.cond, c(I36811 = 10, I36812 = 10)) # adding infection
                  
# running simulations, check num of cores available (num.cores)
sim.results <- hybridModel(network = networkSample, var.names = var.names,
                           model.parms = model.parms, state.var = state.var,
                           prop.func = prop.func, init.cond = init.cond,
                           state.change.matrix = state.change.matrix,
                           sim.number = 2, num.cores = 2)

# default plot layout (plot.types: 'pop.mean', 'subpop', or 'subpop.mean')
plot(sim.results, plot.type = 'subpop.mean')

# changing plot layout with ggplot2 (example)
# uncomment the lines below to test new layout exemple
#library(ggplot2)
#plot(sim.results, plot.type = 'subpop') + ggtitle('New Layout') + 
#  theme_bw() + theme(axis.title = element_text(size = 14, face = "italic"))

}
\references{
[1] Fernando S. Marques, Jose H. H. Grisi-Filho, Marcos Amaku et al.
    hybridModels: An R Package for the Stochastic Simulation of Disease Spreading
    in Dynamic Network. In: Jounal of Statistical Software Volume 94, Issue 6
    <doi:10.18637/jss.v094.i06>.
}
