% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_model_class.R, R/custom_infl.R,
%   R/custom_migr.R, R/si_wo_demogr_infl.R, R/si_wo_demogr_migr.R
\name{buildModelClass}
\alias{buildModelClass}
\alias{buildModelClass.customInfl}
\alias{buildModelClass.customMigr}
\alias{buildModelClass.siWoDemogrInfl}
\alias{buildModelClass.siWoDemogrMigr}
\title{It builds an object of a pre-specified class.}
\usage{
buildModelClass(
  x,
  var.names,
  init.cond,
  model.parms,
  probWeights,
  emigrRule,
  prop.func = NULL,
  state.var = NULL,
  infl.var = NULL,
  state.change.matrix = NULL
)

\method{buildModelClass}{customInfl}(
  x,
  var.names,
  init.cond,
  model.parms,
  probWeights,
  emigrRule,
  prop.func,
  state.var,
  infl.var,
  state.change.matrix
)

\method{buildModelClass}{customMigr}(
  x,
  var.names,
  init.cond,
  model.parms,
  probWeights,
  emigrRule,
  prop.func,
  state.var,
  infl.var,
  state.change.matrix
)

\method{buildModelClass}{siWoDemogrInfl}(
  x,
  var.names,
  init.cond,
  model.parms,
  probWeights,
  emigrRule,
  prop.func,
  state.var,
  infl.var,
  state.change.matrix
)

\method{buildModelClass}{siWoDemogrMigr}(
  x,
  var.names,
  init.cond,
  model.parms,
  probWeights,
  emigrRule,
  prop.func,
  state.var,
  infl.var,
  state.change.matrix
)
}
\arguments{
\item{x}{is an empty object of a class requested.}

\item{var.names}{a \code{\link{list}} with variable names of the network:
the donor node, the receiver node, the time when each connection between
donor to the receiver happened and the weight of these connection.
The variables names must be "from", "to", "Time" and "arc", respectively.}

\item{init.cond}{a named \code{\link{vector}} with initial conditions.}

\item{model.parms}{a named \code{\link{vector}} with model's parameters.}

\item{probWeights}{a named \code{\link{vector}} (optional and for migration type
only) mapping state variables to migration probability weights based on
state variables. These argument can be used to give weights for sampling
individuals from node. They need not sum to one, they should be
non-negative and not zero. For more information on the sampling method
\link[base]{sample}.}

\item{emigrRule}{a string (optional and for migration type only) stating how
many individual emigrate based on state variables. It requires that the
network have weights instead of number of individuals that migrate.}

\item{prop.func}{a character \code{\link{vector}} with propensity functions
of a generic node. See references for more details}

\item{state.var}{a character \code{\link{vector}} with the state variables of
the propensity functions.}

\item{infl.var}{a named \code{\link{vector}} mapping state variables to influence
variables.}

\item{state.change.matrix}{is a state-change \code{\link{matrix}}. See references
for more details}
}
\value{
An object of the class requested.
}
\description{
\code{buildModelClass} is generic function that calls a method
              to create a object base on model's name.
}
\references{
.
}
