% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpohhsphase.R
\name{.rpohhsphase}
\alias{.rpohhsphase}
\title{Reconstruct half-sib groups by recursive clustering with a recombination stop rule}
\usage{
.rpohhsphase(
  genotypeMatrix,
  oh,
  forwardVectorSize = 30,
  excludeFP = TRUE,
  nsap = 3,
  maxRec = 15
)
}
\arguments{
\item{genotypeMatrix}{Numeric genotype matrix (individuals in rows, SNPs in
columns) coded as `0`, `1`, `2` (and typically `9` for missing), as used by
hsphase. This matrix is subset recursively when splitting clusters.}

\item{oh}{A square opposing-homozygote matrix for the same individuals as
\code{genotypeMatrix} (rownames/colnames are individual IDs). Typically
produced by \code{\link{ohg}}. This matrix is subset recursively along with
\code{genotypeMatrix}.}

\item{forwardVectorSize}{Integer. Passed to \code{\link{bmh}} when computing
recombination blocks inside each candidate cluster.}

\item{excludeFP}{Logical. Passed to \code{\link{bmh}}.}

\item{nsap}{Integer. Passed to \code{\link{bmh}}.}

\item{maxRec}{Integer. Maximum allowed recombination count (within a cluster)
before the cluster is recursively split again.}
}
\value{
A \code{data.frame} with two columns:
\itemize{
  \item \code{id}: individual IDs
  \item \code{group}: an integer-like group label assigned by the recursive
  procedure
}
}
\description{
Internal helper used by \code{\link{rpoh}} (reconstruction pedigree of half-sib
families). This function recursively splits individuals into two clusters using
hierarchical clustering on a distance derived from the provided opposing
homozygote (OH) matrix, and then decides whether each cluster should be split
further by checking the maximum number of recombination events inferred within
that cluster.
}
\details{
The recursive splitting stops for a cluster when the maximum recombination
count in that cluster is \code{<= maxRec}. Final group assignments are written
to a temporary file and then read back as a two-column data frame.


The algorithm:
\enumerate{
  \item Converts \code{oh} to a distance object via \code{as.dist(.fastdist(oh))}
  and performs hierarchical clustering (\code{hclust}, Ward method).
  \item Splits into \code{k = 2} clusters via \code{cutree}.
  \item For each cluster with at least 4 individuals, computes recombination
  counts as \code{recombinations(bmh(subGenotype, ...))} and uses the maximum
  recombination count as a stop/split criterion.
  \item If \code{max(recombinations) > maxRec}, the cluster is split again
  recursively; otherwise, individuals in that cluster are assigned a new group
  label and written to a temporary file.
}
}
\section{Implementation notes}{

\itemize{
  \item This function uses a fixed temporary filename \code{"temp.txt"} in the
  current working directory and deletes it at the end. This is not safe under
  parallel execution or if the working directory is not writable.
  \item Group labels are generated using \code{rnorm()}, so results are not
  deterministic unless a seed is set and the recursion order remains identical.
}
}

\seealso{
\code{\link{rpoh}}, \code{\link{ohg}}, \code{\link{bmh}},
\code{\link{recombinations}}, \code{\link{.fastdist}}
}
\keyword{internal}
