% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prSimple.R
\name{.prSimple}
\alias{.prSimple}
\title{Simple recursive clustering using an OH matrix with a linear threshold rule}
\usage{
.prSimple(oh, snpNooh, intercept = 26.3415, coefficient = 77.3171)
}
\arguments{
\item{oh}{A numeric matrix representing opposing-homozygotes (OH) counts
between individuals. Row and column names should be individual IDs. The
matrix is expected to be square and symmetric.}

\item{snpNooh}{Numeric scalar. Number of SNPs used for OH calculation (or a
proxy for SNP density) used to derive the stopping threshold.}

\item{intercept}{Numeric scalar. Intercept for the linear threshold rule.}

\item{coefficient}{Numeric scalar. Slope for the linear threshold rule.}
}
\value{
A \code{data.frame} with columns:
\describe{
  \item{id}{Individual ID (character).}
  \item{group}{An integer-like group code (generated randomly; not reproducible).}
}
}
\description{
Performs a recursive hierarchical clustering on an opposing-homozygotes (OH)
matrix using Ward clustering. Clusters are split until the maximum within-
cluster OH value is below a threshold computed from the number of SNPs
(\code{snpNooh}) using a linear rule.
}
\details{
The threshold is computed as:
\deqn{maxsnpnooh = (intercept + coefficient * snpNooh) - 15 * snpNooh}

The function returns a two-column data frame with individual IDs and a group
code. Group codes are generated randomly (via \code{rnorm()}) and therefore
are not stable across runs.


The recursion proceeds as follows:
\enumerate{
  \item Compute a distance object from \code{oh} using \code{.fastdist} and
  convert it to a \code{dist} object.
  \item Apply hierarchical clustering using \code{\link[stats]{hclust}} with
  \code{method = "ward.D"}.
  \item Cut the dendrogram into two groups using \code{\link[stats]{cutree}}.
  \item For each group, compute the maximum within-group OH value; if it
  exceeds \code{maxsnpnooh} and the group has more than two individuals,
  recurse into that subgroup. Otherwise, write group assignments and stop.
}
}
\section{Side effects}{

This function writes to and reads from a file named \code{"temp.txt"} in the
current working directory, and then deletes it.
}

\seealso{
\code{\link[stats]{hclust}}, \code{\link[stats]{cutree}},
  \code{\link[stats]{as.dist}}
}
\keyword{internal}
