% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HRF_calc.R
\name{HRF_calc}
\alias{HRF_calc}
\title{Canonical HRF and Derivatives}
\usage{
HRF_calc(
  t,
  deriv = 0,
  a1 = 6,
  b1 = 1,
  a2 = 16/6 * a1 * sqrt(b1),
  b2 = b1,
  c = 1/6,
  o = 0
)
}
\arguments{
\item{t}{time vector (in units of seconds)}

\item{deriv}{\code{0} (default) for the HRF, \code{1} for the delay derivative
of the HRF, or \code{2} for the dispersion derivative of the HRF.}

\item{a1}{delay of response. Default: \code{6}}

\item{b1}{response dispersion. Default: \code{1}}

\item{a2}{delay of undershoot. Default: \code{16/6 * a1 * sqrt(b1) = 16}}

\item{b2}{dispersion of undershoot. Default: \code{b1 = 1}}

\item{c}{scale of undershoot. Default: \code{1/6}}

\item{o}{onset of response. Default: \code{0}}
}
\value{
HRF vector (or dHRF, or d2HRF) corresponding to time vector t
}
\description{
Calculate the HRF from a time vector and parameters, or its derivative with
respect to delay or dispersion.
}
\examples{
samples_per_sec <- 200
nsec <- 50
HRF_calc(seq(nsec*samples_per_sec)/samples_per_sec)

}
