% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_hamming_holland.R
\name{con_hamming_holland}
\alias{con_hamming_holland}
\title{Congruence Index based on the Hamming distance}
\usage{
con_hamming_holland(a, b, costs = "hexa", weights = c(1.5, 1.25, 1))
}
\arguments{
\item{a}{a character vector with person Holland codes.}

\item{b}{a character vector with environment Holland codes.}

\item{costs}{character with default set to \code{costs = "hexa"} to use a matrix with replacement costs based on the RIASEC structure for the calculation of the distance.}

\item{weights}{a numeric vector with length equal to \code{a} and \code{b} assigning a weight to the places (1:6) of the letter-codes defined in \code{a} and \code{b}.}
}
\value{
a numeric with value for congruence.
}
\description{
The function computes the location-weighted, cost-sensitive Hammig distance (Hamming, 1950).
}
\details{
The function finds the distance according to Hamming (1950) between two sequences (see Abbott, 1995), which are the Holland codes given in argument a, which is the person code, and argument b, which is the environment code.
}
\examples{
con_hamming_holland(a="RIA",b="SEC") # max. difference 
con_hamming_holland(a="RIA",b="RIA") # max. similarity
con_hamming_holland(a="RIASEC",b="SECRIA", weights=c(1.5,1.25,1,0.75,0.5,0.25)) # max. difference
}
\references{
Holland, J.L. 1963. A theory of vocational choice. I. Vocational images and choice. \emph{Vocational Guidance Quarterly, 11}(4), 232–239.

Hamming, R. (1950). Error detecting and error correcting codes. \emph{Bell System Technical Journal, The, 29}(2), 147–160.

Abbott, A. (1995, August). Sequence Analysis: New Methods for Old Ideas. \emph{Annual Review of Sociology}, 21, 93–113.
}
\keyword{congruence}
