% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kbfit.R
\name{kbfit}
\alias{kbfit}
\title{Kriging Best Fit: kbfit - Fit variogram models and kriging models to spatial data and select the best model based on the metrics values}
\usage{
kbfit(response, formula, data, models, initial_values)
}
\arguments{
\item{response}{A character string specifying the response variable}

\item{formula}{A formula object specifying the model to fit: response ~ predictors}

\item{data}{A simple feature object containing the variables in the formula}

\item{models}{A list of characters vector specifying the variogram models to fit}

\item{initial_values}{A list of named numeric vectors specifying the initial values for the variogram models: psill, range, nugget}
}
\value{
A list with two elements: all_models and best_model
}
\description{
Kriging Best Fit: kbfit - Fit variogram models and kriging models to spatial data and select the best model based on the metrics values
}
\examples{
\dontrun{
# This is a dontrun example because it requires a spatial data object(data_sf).
# Try different initial values for fitting the variogram models
initial_values <- list(
  list(psill = 1, range = 100000, nugget = 10),
  list(psill = 0.5, range = 50000, nugget = 5),
  list(psill = 2, range = 150000, nugget = 15)
)

# Set some models to fit
models <- c("Sph", "Exp", "Gau")

# Select Best: Fit variogram models and kriging models
result <- hmsidwR::kbfit(response = "response",
                   formula = response ~ predictor1 + predictor2,
                   data = data_sf,
                   models = c("Sph", "Exp", "Gau", "Mat"),
                   initial_values = initial_values)

result$all_models
result$best_model
}
}
