% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiwaveplot.R
\name{wave_points}
\alias{wave_points}
\title{Multiple Wave Point Plotting}
\usage{
wave_points(
  waves,
  input_names,
  surround = FALSE,
  p_size = 1.5,
  zero_in = TRUE,
  wave_numbers = ifelse(zero_in, 0, 1):(length(waves) - ifelse(zero_in, 1, 0)),
  ...
)
}
\arguments{
\item{waves}{The list of data.frames, one for each set of points at that wave.}

\item{input_names}{The input names to be plotted.}

\item{surround}{If true, points are surrounded by black boundaries.}

\item{p_size}{The size of the points. Smaller values are better for high-dimensional spaces.}

\item{zero_in}{Is a wave 0 included in the waves list?}

\item{wave_numbers}{Which waves to plot}

\item{...}{Optional parameters (not to be used directly)}
}
\value{
A ggplot object
}
\description{
Given multiple waves of points, produces pairs plots
}
\details{
Subsequent waves are overlaid on the same pairs plots, to determine the
evolution of the non-implausible region. One-dimensional density plots
are also created on the diagonal.
}
\examples{
 wave_points(SIRMultiWaveData, c('aSI', 'aIR', 'aSR'))
 \donttest{
     wave_points(SIRMultiWaveData, c('aSI', 'aIR', 'aSR'), TRUE, 0.8)
     # For many plots, it may be helpful to manually modify the font size
     wave_points(SIRMultiWaveData, c('aSI', 'aIR', 'aSR')) +
      ggplot2::theme(text = ggplot2::element_text(size = 5))
 }
}
\seealso{
Other visualisation tools: 
\code{\link{behaviour_plot}()},
\code{\link{diagnostic_wrap}()},
\code{\link{effect_strength}()},
\code{\link{emulator_plot}()},
\code{\link{hit_by_wave}()},
\code{\link{output_plot}()},
\code{\link{plot_actives}()},
\code{\link{plot_lattice}()},
\code{\link{plot_wrap}()},
\code{\link{simulator_plot}()},
\code{\link{space_removed}()},
\code{\link{validation_pairs}()},
\code{\link{wave_dependencies}()},
\code{\link{wave_values}()}
}
\concept{visualisation tools}
