% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotVolAndDrift.R
\name{spotDrift}
\alias{spotDrift}
\title{Spot Drift Estimation}
\usage{
spotDrift(
  data,
  method = "mean",
  alignBy = "minutes",
  alignPeriod = 5,
  marketOpen = "09:30:00",
  marketClose = "16:00:00",
  tz = NULL,
  ...
)
}
\arguments{
\item{data}{Can be one of two input types, \code{xts} or \code{data.table}. It is assumed that the input comprises prices in levels.}

\item{method}{Which method to be used to estimate the spot-drift. Currently, three methods are available, 
rolling mean and median as well as the kernel method of Christensen et al. (2018).
The kernel is a left hand exponential kernel that will weigh newer observations more heavily than older observations.}

\item{alignBy}{character, indicating the time scale in which \code{alignPeriod} is expressed. 
Possible values are: \code{"ticks"}, \code{"secs"}, \code{"seconds"}, \code{"mins"}, \code{"minutes"}, \code{"hours"}}

\item{alignPeriod}{How often should the estimation take place? If \code{alignPeriod} is 5 the estimation will be done every fifth unit of \code{alignBy}.}

\item{marketOpen}{Opening time of the market, standard is "09:30:00".}

\item{marketClose}{Closing time of the market, standard is "16:00:00".}

\item{tz}{fallback time zone used in case we we are unable to identify the timezone of the data, by default: \code{tz = NULL}. 
We attempt to extract the timezone from the \code{DT} column (or index) of the data, which may fail. 
In case of failure we use \code{tz} if specified, and if it is not specified, we use \code{"UTC"}.}

\item{...}{Additional arguments for the individual methods. See `Details'.}
}
\value{
An object of class \code{"spotDrift"} containing at least the estimated spot drift process. 
Input on what this class should contain and methods for it is welcome.
}
\description{
Function used to estimate the spot drift of intraday (tick) stock prices/returns
}
\details{
The additional arguments for the mean and median methods are: 
\itemize{
\item \code{periods} for the rolling window length which is 5 by default.
\item \code{align} controls the alignment. The default is \code{"right"}. 
}
For the kernel mean estimator, the arguments \code{meanBandwidth} can be used to control the bandwidth of the 
drift estimator and the \code{preAverage} argument, which can be used to control the pre-averaging horizon. 
These arguments default to 300 and 5 respectively.

The following estimation methods can be specified in \code{method}:

\strong{Rolling window mean (\code{"mean"})}

Estimates the spot drift by applying a rolling mean over returns.
\deqn{
    \hat{\mu_{t}} = \sum_{t = k}^{T} \textrm{mean} \left(r_{t-k : t} \right),
}
where \eqn{k} is the argument \code{periods}.
Parameters:
\describe{
   \item{\code{periods}}{ how big the window for the estimation should be. The estimator will have \code{periods} \code{NA}s at the beginning of each trading day.}
   \item{\code{align}}{ alignment method for returns. Defaults to \code{"left"}, which includes only past data, but other choices, \code{"center"} and \code{"right"} are available.
    Warning: These values includes future data.}
}
Outputs:
\describe{
 \item{\code{mu}}{a matrix containing the spot drift estimates}
}
  
\strong{Rolling window median (\code{"median"})}

Estimates the spot drift by applying a rolling mean over returns.
\deqn{
    \hat{\mu_{t}} = \sum_{t = k}^{T} \textrm{median} \left(r_{t-k : t} \right),
}
where \eqn{k} is the argument \code{periods}.
Parameters:
 \describe{
   \item{\code{periods}}{ How big the window for the estimation should be. The estimator will have \code{periods} \code{NA}s at the beginning of each trading day.}
   \item{\code{align}}{ Alignment method for returns. Defaults to \code{"left"}, which includes only past data, but other choices, \code{"center"} and \code{"right"} are available.
    These values includes FUTURE DATA, so beware!}
}
Outputs:
\describe{
 \item{\code{mu}}{a matrix containing the spot drift estimates}
}

\strong{kernel spot drift estimator (\code{"kernel"})}

\deqn{
    dX_{t} = \mu_{t}dt + \sigma_{t}dW_{t} + dJ_{t},
}
where \eqn{\mu_{t}}, \eqn{\sigma_{t}}, and \eqn{J_{t}} are the spot drift, the spot volatility, and a jump process respectively.
However, due to microstructure noise, the observed log-price is 
\deqn{
    Y_{t} = X_{t} + \varepsilon_{t}
}

In order robustify the results to the presence of market microstructure noise, the pre-averaged returns are used:
\deqn{
    \Delta_{i}^{n}\overline{Y} = \sum_{j=1}^{k_{n}-1}g_{j}^{n}\Delta_{i+j}^{n}Y,
}

where \eqn{g(\cdot)} is a weighting function, \eqn{min(x, 1-x)}, and \eqn{k_{n}} is the pre-averaging horizon.
The spot drift estimator is then:
\deqn{
    \hat{\bar{\mu}}_{t}^{n} = \sum_{i=1}^{n-k_{n}+2}K\left(\frac{t_{i-1}-t}{h_{n}}\right)\Delta_{i-1}^{n}\overline{Y},
}
The kernel estimation method has the following parameters:
 \describe{
   \item{\code{preAverage}}{ a positive \code{integer} denoting the length of pre-averaging window for the log-prices. Default is 5}
   \item{\code{meanBandwidth}}{ an \code{integer} denoting the bandwidth for the left-sided exponential kernel for the mean. Default is \code{300L}}
}
Outputs:
\describe{
 \item{\code{mu}}{a matrix containing the spot drift estimates}
}
}
\examples{
# Example 1: Rolling mean and median estimators for 2 days
meandrift <- spotDrift(data = sampleTData, alignPeriod = 1)
mediandrift <- spotDrift(data = sampleTData, method = "median", 
                         alignBy = "seconds", alignPeriod = 30, tz = "EST")
plot(meandrift)
plot(mediandrift)
\dontrun{
# Example 2: Kernel based estimator for one day with data.table format
price <- sampleTData[as.Date(DT) == "2018-01-02", list(DT, PRICE)]
kerneldrift <- spotDrift(sampleTDataEurope, method = "driftKernel",
                         alignBy = "minutes", alignPeriod = 1)
plot(kerneldrift)
}

}
\references{
Christensen, K., Oomen, R., and Reno, R. (2020) The drift burst hypothesis. Journal of Econometrics. Forthcoming.
}
\author{
Emil Sjoerup.
}
\keyword{Drift}
