% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{hyperSharpeMax}
\alias{hyperSharpeMax}
\title{Hypervolume Sharpe ratio maximization}
\usage{
hyperSharpeMax(A, l, u, eps = sqrt(.Machine$double.eps))
}
\arguments{
\item{A}{matrix of assets, in R^p}

\item{l, u}{vector of lower and upper bounds in R^p}

\item{eps}{jitter used in the inversion of the covariance matrix for numerical stability}
}
\value{
list with the allocation vector a, corresponding Sharpe ratio value, return vector r and the covariance Q.
}
\description{
Hypervolume Sharpe ratio maximization
}
\examples{
################################################################################
### 2 objectives example
################################################################################
set.seed(42)
nA <- 20 # Number of assets
p <- 2 # Number of objectives
A <- matrix(runif(nA * p), nA)
sol <- hyperSharpeMax(A = A, l = c(0, 0), u = c(1, 1))
plot(A, pch = 20, xlim = c(0, 1), ylim = c(0, 1))
points(A[which(sol$par > 1e-6),,drop = FALSE], col = 2)
}
\references{
A. P. Guerreiro, C. M. Fonseca,
Hypervolume Sharpe-Ratio indicator: Formalization and first theoretical results,
International Conference on Parallel Problem Solving from Nature, 2016, 814-823.
}
