% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_mats.R
\name{create_input_mats}
\alias{create_input_mats}
\alias{create_input_mats.lm}
\alias{create_input_mats.flexsurvreg}
\alias{create_input_mats.flexsurvreg_list}
\alias{create_input_mats.partsurvfit}
\alias{create_input_mats.params_lm}
\alias{create_input_mats.params_surv}
\alias{create_input_mats.params_surv_list}
\alias{create_input_mats.multinom}
\alias{create_input_mats.multinom_list}
\alias{create_input_mats.params_mlogit_list}
\title{Create input matrices}
\usage{
create_input_mats(object, ...)

\method{create_input_mats}{lm}(object, input_data, ...)

\method{create_input_mats}{flexsurvreg}(object, input_data, ...)

\method{create_input_mats}{flexsurvreg_list}(object, input_data, ...)

\method{create_input_mats}{partsurvfit}(object, input_data, ...)

\method{create_input_mats}{params_lm}(object, input_data, ...)

\method{create_input_mats}{params_surv}(object, input_data, ...)

\method{create_input_mats}{params_surv_list}(object, input_data, ...)

\method{create_input_mats}{multinom}(object, input_data, ...)

\method{create_input_mats}{multinom_list}(object, input_data, ...)

\method{create_input_mats}{params_mlogit_list}(object, input_data, ...)
}
\arguments{
\item{object}{An object of the appropriate class.}

\item{...}{Further arguments passed to \code{\link[=model.matrix]{model.matrix()}}.}

\item{input_data}{An object of class \code{expanded_hesim_data} returned by
\code{\link[=expand.hesim_data]{expand.hesim_data()}}. It is used to look for the variables needed to create
an input matrix for use in a statistical models and the ID variables for
indexing rows in the input matrix.}
}
\value{
An object of class \code{input_mats}.
}
\description{
\code{create_input_mats()} is a generic function for creating an object of class
\code{\link{input_mats}}. Model matrices are constructed based on the
variables specified in the model \code{object} and the data specified in \code{input_data}.
\code{create_input_mats()} is not typically called by users directly, but is
instead used by functions that create model objects (e.g.,
\code{\link[=create_IndivCtstmTrans]{create_IndivCtstmTrans()}}, \code{\link[=create_CohortDtstmTrans]{create_CohortDtstmTrans()}},
\code{\link[=create_PsmCurves]{create_PsmCurves()}}).
}
\examples{
library("flexsurv")

strategies <- data.frame(strategy_id = c(1, 2))
patients <- data.frame(patient_id = seq(1, 3),
                       age = c(45, 47, 60),
                       female = c(1, 0, 0),
                       group = factor(c("Good", "Medium", "Poor")))
states <- data.frame(state_id =  seq(1, 3),
                     state_name = factor(paste0("state", seq(1, 3))))
hesim_dat <- hesim_data(strategies = strategies,
                        patients = patients,
                        states = states)

# Class "lm"
input_data <- expand(hesim_dat, by = c("strategies", "patients", "states"))
medcost_fit <- lm(costs ~ female + state_name, psm4_exdata$costs$medical)
input_mats <- create_input_mats(medcost_fit, input_data)
input_mats

# Class "flexsurvreg"
input_data <- expand(hesim_dat, by = c("strategies", "patients"))
fit_wei <- flexsurvreg(formula = Surv(futime, fustat) ~ 1,
                       data = ovarian, dist = "weibull")
input_mats <- create_input_mats(fit_wei, input_data)
input_mats
}
\seealso{
\code{\link[=input_mats]{input_mats()}}
}
\keyword{internal}
