% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Bees}
\alias{Bees}
\title{Captive and maltreated bees}
\format{
A data frame with 246 observations on the following 6 variables.
\describe{
\item{\code{caste}}{a factor with levels \code{Queen} \code{Worker}}
\item{\code{treat}}{a factor with levels \code{""} \code{CAP} \code{MAL}}
\item{\code{time}}{an ordered factor: time of treatment}
\item{\code{Iz}}{an index of ovarian development}
\item{\code{Iy}}{an index of ovarian reabsorption}
\item{\code{trtime}}{a factor with levels \code{0} \code{CAP05} \code{CAP07} \code{CAP10}
\code{CAP12} \code{CAP15} \code{MAL05} \code{MAL07} \code{MAL10}
\code{MAL12} \code{MAL15}}
}
}
\source{
Pabalan, N., Davey, K. G. & Packe, L. (2000). Escalation of
Aggressive Interactions During Staged Encounters in Halictus ligatus Say
(Hymenoptera: Halictidae), with a Comparison of Circle Tube Behaviors with
Other Halictine Species \emph{Journal of Insect Behavior}, \strong{13},
627-650.
}
\description{
Pabalan, Davey and Packe (2000) studied the effects of captivity and
maltreatment on reproductive capabilities of queen and worker bees in a
complex factorial design.
}
\details{
Bees were placed in a small tube and either held captive (CAP) or shaken
periodically (MAL) for one of 5, 7.5, 10, 12.5 or 15 minutes, after which
they were sacrificed and two measures: ovarian development (\code{Iz}) and
ovarian reabsorption (\code{Iy}), were taken. A single control group was
measured with no such treatment, i.e., at time 0; there are n=10 per group.

The design is thus nearly a three-way factorial, with factors \code{caste}
(Queen, Worker), \code{treat} (CAP, MAL) and \code{time}, except that there
are only 11 combinations of Treatment and Time; we call these \code{trtime}
below.

Models for the three-way factorial design, using the formula
\code{cbind(Iz,Iy) ~ caste*treat*time} ignore the control condition at
\code{time==0}, where \code{treat==NA}.

To handle the additional control group at \code{time==0}, while separating
the effects of Treatment and Time, 10 contrasts can be defined for the
\code{trtime} factor in the model \code{cbind(Iz,Iy) ~ caste*trtime} See
\code{demo(bees.contrasts)} for details.

In the \code{heplot} examples below, the default \code{size="evidence"}
displays are too crowded to interpret, because some effects are so highly
significant.  The alternative effect-size scaling, \code{size="effect"},
makes the relations clearer.
}
\examples{

data(Bees)
require(car)

# 3-way factorial, ignoring 0 group
bees.mod <- lm(cbind(Iz,Iy) ~ caste*treat*time, data=Bees)
car::Anova(bees.mod)

op<-palette(c(palette()[1:4],"brown","magenta", "olivedrab","darkgray"))
heplot(bees.mod, 
    xlab="Iz: Ovarian development", 
    ylab="Iz: Ovarian reabsorption",
		main="Bees: ~caste*treat*time")

heplot(bees.mod, size="effect",
    xlab="Iz: Ovarian development", 
    ylab="Iz: Ovarian reabsorption",
    main="Bees: ~caste*treat*time", 
    )

# two-way design, using trtime
bees.mod1 <- lm(cbind(Iz,Iy) ~ caste*trtime, data=Bees)
Anova(bees.mod1)

# HE plots for this model, with both significance and effect size scaling

heplot(bees.mod1, 
    xlab="Iz: Ovarian development", 
    ylab="Iz: Ovarian reabsorption",
		main="Bees: ~caste*trtime")
heplot(bees.mod1, 
    xlab="Iz: Ovarian development", 
    ylab="Iz: Ovarian reabsorption",
    main="Bees: ~caste*trtime",
    size="effect")
palette(op)

# effect plots for separate responses
if(require(effects)) {
	bees.lm1 <-lm(Iy ~ treat*caste*time, data=Bees)
	bees.lm2 <-lm(Iz ~ treat*caste*time, data=Bees)
	
	bees.eff1 <- allEffects(bees.lm1)
	plot(bees.eff1,multiline=TRUE,ask=FALSE)
	
	bees.eff2 <- allEffects(bees.lm2)
	plot(bees.eff2,multiline=TRUE,ask=FALSE)
}


}
\references{
Friendly, M. (2006). Data Ellipses, HE Plots and Reduced-Rank
Displays for Multivariate Linear Models: SAS Software and Examples
\emph{Journal of Statistical Software}, \strong{17}, 1-42.
}
\concept{MANOVA}
\keyword{datasets}
