#' 2011-12 FPED Data
#'
#' Raw dietary intake data from the 2011-12 NHANES cycle converted to Food Patterns Equivalents Database components
#'
#' @format ## `fped_1112`
#' A data frame with 9,338 rows and 51 columns:
#' \describe{
#'   \item{SEQN}{Respondent sequence number}
#'   \item{WTDRD1, WTDRD2}{Day 1 and 2 survey weight}
#'   \item{SEX}{Gender of the respondent}
#'   \item{RACE_ETH}{Race/Ethnicity of the respondent}
#'   \item{AGE}{Age of the respondent (in years)}
#'   \item{FAMINC}{Family income category of the respondent (in USD)}
#'   \item{DR1TKCAL, DR2TKCAL}{Day 1 and 2 kilocalories consumed}
#'   \item{DR1T_F_TOTAL, DR2T_F_TOTAL}{Day 1 and 2 total intact or cut fruits and fruit juices consumed (in cups)}
#'   \item{DR1_FWHOLEFRT, DR2_FWHOLEFRT}{Day 1 and 2 total intact or cut fruits consumed (in cups)}
#'   \item{DR1T_F_JUICE, DR2T_F_JUICE}{Day 1 and 2 fruit juices consumed (in cups)}
#'   \item{DR1_VTOTALLEG, DR2_VTOTALLEG}{Day 1 and 2 vegetables and legumes consumed (in cups)}
#'   \item{DR1_VDRKGRLEG, DR2_VDRKGRLEG}{Day 1 and 2 dark green vegetables and legumes consumed (in cups)}
#'   \item{DR1_VNONDRKGR, DR2_VNONDRKGR}{Day 1 and 2 non-dark green vegetables and legumes consumed (in cups)}
#'   \item{DR1T_V_DRKGR, DR2T_V_DRKGR}{Day 1 and 2 dark green vegetables consumed (in cups)}
#'   \item{DR1T_V_LEGUMES, DR2T_V_LEGUMES}{Day 1 and 2 legumes consumed, where legumes are computed as vegetables (in cups)}
#'   \item{DR1T_G_WHOLE, DR2T_G_WHOLE}{Day 1 and 2 whole grains consumed (in ounces)}
#'   \item{DR1T_D_TOTAL, DR2T_D_TOTAL}{Day 1 and 2 total milk, yogurt, cheese, and whey consumed (in cups)}
#'   \item{DR1_PFALLPROTLEG, DR2_PFALLPROTLEG}{Day 1 and 2 total animal and plant proteins consumed, including meat, poultry, fish, eggs, nuts, seeds, soy, and legumes (in ounces)}
#'   \item{DR1_PFSEAPLANTLEG, DR2_PFSEAPLANTLEG}{Day 1 and 2 total seafood, nuts, seeds, soy products (other than beverages), and legumes consumed (in ounces)}
#'   \item{DR1_PF_MPE, DR2_PF_MPE}{Day 1 and 2 total Meat, Poultry (including organ meats and cured meats), and Eggs consumed (in ounces)}
#'   \item{DR1_PF_SSNS, DR2_PF_SSNS}{Day 1 and 2 total Seafood, Soy, Nuts, and Seeds consumed (in ounces)}
#'   \item{DR1T_PF_LEGUMES, DR2T_PF_LEGUMES}{Day 1 and 2 legumes consumed, where legumes are computed as protein foods (in ounces)}
#'   \item{DR1_TFACIDS, DR2_TFACIDS}{Day 1 and 2 ratios of total poly- and mono-unsaturated fatty acids to saturated fatty acids consumed}
#'   \item{DR1T_G_REFINED, DR2T_G_REFINED}{Day 1 and 2 refined or non-whole grains consumed (in ounces)}
#'   \item{DR1TSODI, DR2TSODI}{Day 1 and 2 sodium consumed (in mg)}
#'   \item{DR1T_ADD_SUGARS, DR2T_ADD_SUGARS}{Day 1 and 2 added sugars consumed (in teaspoons)}
#'   \item{DR1TSFAT, DR2TSFAT}{Day 1 and 2 saturated fatty acids consumed (in grams)}
#'   \item{DR1_MONOPOLY, DR2_MONOPOLY}{Day 1 and 2 total Monounsaturated Fatty Acids and Total Polyunsaturated Fatty Acids consumed (in grams)}
#' }
#' @source <https://www.ars.usda.gov/northeast-area/beltsville-md-bhnrc/beltsville-human-nutrition-research-center/food-surveys-research-group/docs/fped-databases/>
"fped_1112"
