% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rh_from_wetbulb.R
\name{rh_from_wetbulb}
\alias{rh_from_wetbulb}
\title{Relative humidity from wet-bulb temperature}
\usage{
rh_from_wetbulb(
  p,
  T,
  Tw,
  psychrometric = FALSE,
  icebulb = FALSE,
  verbose = TRUE,
  lewis = 0.85
)
}
\arguments{
\item{p}{The total air pressuire in Pa. This can be a single number, a vector, a matrix, or an array.}

\item{T}{The absolute air temperature in Kelvin. This can be a single number, a vector, a matrix, or an array.}

\item{Tw}{The thermodynamic (or psychrometric) wet-bulb (or ice-bulb) temperature in Kelving. This can be a single number, a vector, a matrix, or an array.}

\item{psychrometric}{A logical indicating whether to interpret \code{Tw} as the psychrometric (if \code{TRUE}) or thermodynamic (if \code{FALSE}) version. Default is \code{FALSE}.}

\item{icebulb}{A logical indicating whether to interpret \code{Tw} as the ice-bulb (if \code{TRUE}) or wet-bulb (if \code{FALSE}) version. Default is \code{FALSE}.}

\item{verbose}{A logical indicating whether or not to print warning messages. Default is \code{TRUE}.}

\item{lewis}{The Lewis number for moist air. Default is \code{0.85}.}
}
\value{
Relative humidity in the same shape as \code{p}, \code{T}, and \code{Tw}. The relative humidity is reported with respect to liquid water if \code{T} is greater than or equal to 273.16 K and with respect to ice if \code{T} is less than 273.16 K.
}
\description{
\code{rh_from_wetbulb} calculates the relative humidity from the thermodynamic (or psychrometric) wet-bulb (or ice-bulb) temperature using the Rankine-Kirchhoff approximations.
}
\examples{
rh_from_wetbulb(1e5,300,290)
rh_from_wetbulb(1e5,301:310,290)
rh_from_wetbulb(1e5,301:310,291:300)
rh_from_wetbulb(1:10*1e4,301:310,291:300)
}
\references{
Romps, D. M. (2025). Wet-bulb temperature from pressure, relative humidity, and air temperature. In review.
}
\author{
David M. Romps \email{romps@berkeley.edu}
}
