% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{KinData_df}
\alias{KinData_df}
\title{KinData – Kinematics Dataset}
\format{
A data frame with the following variables:
\describe{
  \item{Grip_Aperture_01}{numeric}
  \item{Grip_Aperture_02}{numeric}
  \item{Grip_Aperture_03}{numeric}
  \item{Grip_Aperture_04}{numeric}
  \item{Grip_Aperture_05}{numeric}
  \item{Grip_Aperture_06}{numeric}
  \item{Grip_Aperture_07}{numeric}
  \item{Grip_Aperture_08}{numeric}
  \item{Grip_Aperture_09}{numeric}
  \item{Grip_Aperture_10}{numeric}
  \item{Object.Size}{numeric}
  \item{Wrist_Height_01}{numeric}
  \item{Wrist_Height_02}{numeric}
  \item{Wrist_Height_03}{numeric}
  \item{Wrist_Height_04}{numeric}
  \item{Wrist_Height_05}{numeric}
  \item{Wrist_Height_06}{numeric}
  \item{Wrist_Height_07}{numeric}
  \item{Wrist_Height_08}{numeric}
  \item{Wrist_Height_09}{numeric}
  \item{Wrist_Height_10}{numeric}
  \item{Wrist_Velocity_01}{numeric}
  \item{Wrist_Velocity_02}{numeric}
  \item{Wrist_Velocity_03}{numeric}
  \item{Wrist_Velocity_04}{numeric}
  \item{Wrist_Velocity_05}{numeric}
  \item{Wrist_Velocity_06}{numeric}
  \item{Wrist_Velocity_07}{numeric}
  \item{Wrist_Velocity_08}{numeric}
  \item{Wrist_Velocity_09}{numeric}
  \item{Wrist_Velocity_10}{numeric}
  \item{x_finger_plane_01}{numeric}
  \item{x_finger_plane_02}{numeric}
  \item{x_finger_plane_03}{numeric}
  \item{x_finger_plane_04}{numeric}
  \item{x_finger_plane_05}{numeric}
  \item{x_finger_plane_06}{numeric}
  \item{x_finger_plane_07}{numeric}
  \item{x_finger_plane_08}{numeric}
  \item{x_finger_plane_09}{numeric}
  \item{x_finger_plane_10}{numeric}
  \item{x_index_01}{numeric}
  \item{x_index_02}{numeric}
  \item{x_index_03}{numeric}
  \item{x_index_04}{numeric}
  \item{x_index_05}{numeric}
  \item{x_index_06}{numeric}
  \item{x_index_07}{numeric}
  \item{x_index_08}{numeric}
  \item{x_index_09}{numeric}
  \item{x_index_10}{numeric}
  \item{x_thumb_01}{numeric}
  \item{x_thumb_02}{numeric}
  \item{x_thumb_03}{numeric}
  \item{x_thumb_04}{numeric}
  \item{x_thumb_05}{numeric}
  \item{x_thumb_06}{numeric}
  \item{x_thumb_07}{numeric}
  \item{x_thumb_08}{numeric}
  \item{x_thumb_09}{numeric}
  \item{x_thumb_10}{numeric}
  \item{y_finger_plane_01}{numeric}
  \item{y_finger_plane_02}{numeric}
  \item{y_finger_plane_03}{numeric}
  \item{y_finger_plane_04}{numeric}
  \item{y_finger_plane_05}{numeric}
  \item{y_finger_plane_06}{numeric}
  \item{y_finger_plane_07}{numeric}
  \item{y_finger_plane_08}{numeric}
  \item{y_finger_plane_09}{numeric}
  \item{y_finger_plane_10}{numeric}
  \item{y_index_01}{numeric}
  \item{y_index_02}{numeric}
  \item{y_index_03}{numeric}
  \item{y_index_04}{numeric}
  \item{y_index_05}{numeric}
  \item{y_index_06}{numeric}
  \item{y_index_07}{numeric}
  \item{y_index_08}{numeric}
  \item{y_index_09}{numeric}
  \item{y_index_10}{numeric}
  \item{y_thumb_01}{numeric}
  \item{y_thumb_02}{numeric}
  \item{y_thumb_03}{numeric}
  \item{y_thumb_04}{numeric}
  \item{y_thumb_05}{numeric}
  \item{y_thumb_06}{numeric}
  \item{y_thumb_07}{numeric}
  \item{y_thumb_08}{numeric}
  \item{y_thumb_09}{numeric}
  \item{y_thumb_10}{numeric}
  \item{z_finger_plane_01}{numeric}
  \item{z_finger_plane_02}{numeric}
  \item{z_finger_plane_03}{numeric}
  \item{z_finger_plane_04}{numeric}
  \item{z_finger_plane_05}{numeric}
  \item{z_finger_plane_06}{numeric}
  \item{z_finger_plane_07}{numeric}
  \item{z_finger_plane_08}{numeric}
  \item{z_finger_plane_09}{numeric}
  \item{z_finger_plane_10}{numeric}
  \item{z_index_01}{numeric}
  \item{z_index_02}{numeric}
  \item{z_index_03}{numeric}
  \item{z_index_04}{numeric}
  \item{z_index_05}{numeric}
  \item{z_index_06}{numeric}
  \item{z_index_07}{numeric}
  \item{z_index_08}{numeric}
  \item{z_index_09}{numeric}
  \item{z_index_10}{numeric}
  \item{z_thumb_01}{numeric}
  \item{z_thumb_02}{numeric}
  \item{z_thumb_03}{numeric}
  \item{z_thumb_04}{numeric}
  \item{z_thumb_05}{numeric}
  \item{z_thumb_06}{numeric}
  \item{z_thumb_07}{numeric}
  \item{z_thumb_08}{numeric}
  \item{z_thumb_09}{numeric}
  \item{z_thumb_10}{numeric}
}
}
\source{
Data taken from the \pkg{PredPsych} package version 0.4.
}
\usage{
data(KinData_df)
}
\description{
This dataset, \code{KinData_df}, is a data frame containing part of the motion capture
dataset freely available in the publication by Ansuini et al. (2015). It provides
detailed kinematic measurements of grasping movements across multiple conditions.
}
\details{
The dataset includes information on wrist velocity, grip aperture, wrist height,
and three-dimensional coordinates of the index finger, thumb, and finger plane.
Each measurement is recorded across 10 equally spaced points of the movement
trajectory. The variable \code{Object.Size} indicates the size of the object being grasped.

The dataset name has been kept as \code{KinData_df} to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
\pkg{healthmotionR} package and assists users in identifying its specific characteristics.
The suffix \code{_df} indicates that the dataset is a data frame. The original content has
not been modified in any way.
}
