% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sinan.R
\name{sinan_years}
\alias{sinan_years}
\title{List Available SINAN Years}
\usage{
sinan_years(status = "final")
}
\arguments{
\item{status}{Character. Filter by data status. One of:
\itemize{
\item \code{"final"}: Definitive data only (default).
\item \code{"preliminary"}: Preliminary data only.
\item \code{"all"}: All available data (definitive + preliminary).
}}
}
\value{
An integer vector of available years.
}
\description{
Returns an integer vector with years for which notifiable diseases microdata
are available from DATASUS FTP.
}
\examples{
sinan_years()
sinan_years(status = "all")
}
\seealso{
Other sinan: 
\code{\link{sinan_cache_status}()},
\code{\link{sinan_clear_cache}()},
\code{\link{sinan_data}()},
\code{\link{sinan_dictionary}()},
\code{\link{sinan_diseases}()},
\code{\link{sinan_info}()},
\code{\link{sinan_variables}()}
}
\concept{sinan}
