% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTDmodel.R
\name{MTDmodel}
\alias{MTDmodel}
\title{Creates a Mixture Transition Distribution (MTD) Model}
\usage{
MTDmodel(
  Lambda,
  A,
  lam0 = NULL,
  lamj = NULL,
  pj = NULL,
  p0 = NULL,
  single_matrix = FALSE,
  indep_part = TRUE
)
}
\arguments{
\item{Lambda}{A numeric vector of positive integers representing the relevant lag set.
The elements will be sorted from smallest to greatest. The smallest number represents the latest
(most recent) time in the past, and the largest number represents the earliest time in the past.}

\item{A}{A vector with nonnegative integers representing the state space.}

\item{lam0}{A numeric value in \verb{[0,1)}, representing the weight of the independent distribution.}

\item{lamj}{A numeric vector of weights for the transition probability matrices in \code{pj}.
Values must be in the range \verb{[0, 1)}, and their sum with \code{lam0} must be equal to 1.
The first element in \code{lamj} must be the weight for the first element in \code{Lambda} and so on.}

\item{pj}{A list with \code{length(Lambda)} stochastic matrices, each of size \verb{length(A) x length(A)}.
The first matrix in \code{pj} must refer to the first element in \code{Lambda} and so on.}

\item{p0}{A probability vector for the independent component of the MTD model. If \code{NULL}
and \code{indep_part=TRUE}, the distribution will be sampled from a uniform distribution.
If \code{indep_part=FALSE}, then there is no independent distribution and \code{p0} entries will
be set to zero. If you enter \code{p0=0}, \code{indep_part} is set to \code{FALSE}.}

\item{single_matrix}{Logical. If \code{TRUE}, all matrices in list \code{pj} are identical.}

\item{indep_part}{Logical. If \code{FALSE}, the model does not include an independent distribution
and \code{p0} is set to zero.}
}
\value{
A list of class \code{MTD} containing:
\describe{
\item{\code{P}}{The transition probability matrix of the MTD model.}
\item{\code{lambdas}}{A vector with MTD weights (\code{lam0} and \code{lamj}).}
\item{\code{pj}}{A list of stochastic matrices defining conditional transition probabilities.}
\item{\code{p0}}{The independent probability distribution.}
\item{\code{Lambda}}{The vector of relevant lags.}
\item{\code{A}}{The state space.}
\item{\code{single_matrix}}{A logical argument, if TRUE indicates that all matrices in \code{pj} are identical.}
}
}
\description{
Generates an MTD model as an object of class \code{MTD} given a set of parameters.
}
\section{Methods (S3)}{

Objects returned by \code{MTDmodel()} have class \code{"MTD"} and support:
\itemize{
\item \code{\link[base]{print}}: compact display of the relevant lag set and
the state space (see \code{\link{MTD-methods}}).
\item \code{\link[base]{summary}}: detailed summary of the model components
(see \code{\link{MTD-methods}}).
\item \code{\link[stats]{coef}}: extracts the model parameters \code{lambdas},
\code{pj}, and \code{p0} (see \code{\link{MTD-methods}}).
\item \code{\link[stats]{logLik}}: \code{logLik(object, X)} computes the
log-likelihood, provided that the user supplies a sample \code{X} (see \code{\link{MTD-methods}}).
\item \code{\link[graphics]{plot}}: diagnostic plots, including oscillations by lag, mixture weights,
and transition graphs (see \code{\link{plot.MTD}}).
\item \code{\link{oscillation}}: oscillations by lag computed from the model parameters.
\item \code{\link{perfectSample}}: perfect sampling from the stationary distribution, provided that
\eqn{\lambda_0 > 0}.
\item \code{\link{probs}}: one-step predictive probabilities.
}
}

\section{Accessors}{

Stable access to model components is provided by \code{\link{MTD-accessors}}:
\code{\link{lags}}, \code{\link{Lambda}}, \code{\link{lambdas}}, \code{\link{pj}},
\code{\link{p0}}, \code{\link{states}}, and \code{\link{transitP}}.
}

\examples{
summary(MTDmodel(Lambda = c(1, 3), A = c(4, 8, 12)))

MM <- MTDmodel(Lambda = c(2, 4, 9), A = c(0, 1), lam0 = 0.05,
 lamj = c(0.35, 0.2, 0.4), pj = list(matrix(c(0.5, 0.7, 0.5, 0.3), ncol = 2)),
 p0 = c(0.2, 0.8), single_matrix = TRUE)
transitP(MM); pj(MM); oscillation(MM)


MM <- MTDmodel(Lambda = c(2, 4, 9), A = c(0, 1), lam0 = 0.05,
 pj = list(matrix(c(0.5, 0.7, 0.5, 0.3), ncol = 2)), single_matrix = TRUE,
 indep_part = FALSE)
p0(MM); lambdas(MM)

}
\seealso{
\code{\link{MTDest}} for EM-based parameter estimation,
\code{\link{hdMTD}} for lag selection procedures,
\code{\link{MTD-methods}} for methods applicable to \code{"MTD"} objects,
\code{\link{MTD-accessors}} for stable access to model components,
\code{\link{oscillation}}, \code{\link{perfectSample}}, and \code{\link{probs}}
for additional inference and simulation utilities.
}
