% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{preproc_hcru_fun}
\alias{preproc_hcru_fun}
\title{preproc_hcru_fun}
\usage{
preproc_hcru_fun(
  data,
  cohort_col = "cohort",
  patient_id_col = "patient_id",
  admit_col = "admission_date",
  discharge_col = "discharge_date",
  index_col = "index_date",
  visit_col = "visit_date",
  encounter_id_col = "encounter_id",
  setting_col = "care_setting",
  pre_days = 180,
  post_days = 365,
  readmission_days_rule = 30
)
}
\arguments{
\item{data}{A dataframe specifying the health care details}

\item{cohort_col}{A character specifying the name of the cohort column}

\item{patient_id_col}{A character specifying the name of the patient
identifier column}

\item{admit_col}{A character specifying the name of the date of admission
column}

\item{discharge_col}{A character specifying the name of the date of
discharge column}

\item{index_col}{A character specifying the name of the index date or
diagnosis column}

\item{visit_col}{A character specifying the name of the date of
visit/claim column}

\item{encounter_id_col}{A character specifying the name of the
encounter/claim column}

\item{setting_col}{A character specifying the name of the HCRU
setting column e.g. IP, ED, OP, etc.}

\item{pre_days}{Number of days before index (default 180 days)}

\item{post_days}{Number of days after index (default 365 days)}

\item{readmission_days_rule}{Rule for how many days can be permissible to
define readmission criteria in AP setting (default 30 days)}
}
\value{
dataframe with HCRU estimates.
}
\description{
This function helps to pre-process the heath care resource utilization
(HCRU) for a given electronic health record data for a given set of settings
e.g. IP, OP, ED/ER, etc.
}
\examples{
\donttest{
preproc_hcru_fun(data = hcru_sample_data)
}
}
