% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sim_desc.R
\docType{data}
\name{data_binlogitnorm}
\alias{data_binlogitnorm}
\title{Simulated Binomial–Logit-Normal data (area-level)}
\format{
A data frame with 50 rows and 13 variables:
\describe{
\item{n}{Sample size per area}
\item{y}{Observed success count per area}
\item{p}{Direct estimator of proportion}
\item{x1, x2, x3}{Auxiliary area-level covariates}
\item{u_true}{True area-level random effect}
\item{eta_true}{True linear predictor (logit scale)}
\item{p_true}{True probability per area}
\item{psi_i}{Sampling variance of logit-transformed direct estimator}
\item{y_obs}{Simulated noisy version of eta (logit scale)}
\item{p_obs}{Estimated proportion via inverse logit of y_obs}
\item{group}{Area ID (1–100) for random effects formula specifying the grouping structure in the data. }
\item{sre}{An optional grouping factor mapping observations to spatial locations.}
}
}
\source{
Simulated data based on a Binomial–Logit-Normal model
}
\usage{
data_binlogitnorm
}
\description{
The \code{data_binlogitnorm} dataset contains simulated data for 50 areas based on a
Binomial–Logit-Normal model. It includes area-level covariates, true
probability parameters, sample sizes, observed counts, direct estimators,
sampling variances, and true latent values.
}
\details{
This dataset is intended for evaluating small area estimation models
under Binomial–Logit-Normal assumptions.
}
\keyword{datasets}
