% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/united.R
\docType{data}
\name{nab_realTweets}
\alias{nab_realTweets}
\title{Numenta Anomaly Benchmark (NAB) realTweets}
\format{
A list of time series.
}
\source{
\href{https://github.com/numenta/NAB/tree/master/data}{Numenta Anomaly Benchmark (NAB) Dataset}
}
\usage{
data(nab_realTweets)
}
\description{
Real-world time series with labeled anomalies from Twitter
volumes (NAB). Labels available: Yes.
See \href{https://github.com/cefet-rj-dal/united}{cefet-rj-dal/united}
for detailed guidance on using this package and the other datasets available in it.
Labels available? Yes
}
\details{
This package ships a mini version of the dataset. Use loadfulldata() to download and load the full dataset from the URL stored in attr(url).
}
\examples{
data(nab_realTweets)
s <- nab_realTweets[[1]]
plot(ts(s$value), main = names(nab_realTweets)[1])
mean(s$event)
}
\references{
Lavin, A., & Ahmad, S. (2015). Evaluating real-time anomaly
detection algorithms – the Numenta Anomaly Benchmark. 2015 IEEE 14th
International Conference on Machine Learning and Applications (ICMLA).
}
\keyword{datasets}
