% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls.r
\name{h5_str}
\alias{h5_str}
\title{Display the Structure of an HDF5 Object}
\usage{
h5_str(file, name = "/", attrs = TRUE, members = TRUE, markup = interactive())
}
\arguments{
\item{file}{The path to the HDF5 file.}

\item{name}{The name of the group or dataset to display. Defaults to the root
group "/".}

\item{attrs}{Set to \code{FALSE} to hide attributes. The default (\code{TRUE}) shows
attributes prefixed with \code{@}.}

\item{members}{Set to \code{FALSE} to hide compound dataset members. The default
(\code{TRUE}) shows members prefixed with \code{$}.}

\item{markup}{Set to \code{FALSE} to remove colors and italics from the output.}
}
\value{
This function is called for its side-effect of printing to the
console and returns \code{NULL} invisibly.
}
\description{
Recursively prints a summary of an HDF5 group or dataset, similar to
the structure of \code{h5ls -r}. It displays the nested structure, object types,
dimensions, and attributes.
}
\details{
This function provides a quick and convenient way to inspect the contents of
an HDF5 file. It performs a recursive traversal of the file from the C-level
and prints a formatted summary to the R console.

This function \strong{does not read any data} into R. It only inspects the
metadata (names, types, dimensions) of the objects in the file, making it
fast and memory-safe for arbitrarily large files.
}
\examples{
file <- tempfile(fileext = ".h5")
h5_write(list(x = 1:10, y = matrix(1:9, 3, 3)), file, "group")
h5_write("metadata", file, "group", attr = "info")

# Print structure
h5_str(file)

unlink(file)
}
\seealso{
\code{\link[=h5_ls]{h5_ls()}}, \code{\link[=h5_attr_names]{h5_attr_names()}}
}
