% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.r
\name{h5_length}
\alias{h5_length}
\title{Get the Total Length of an HDF5 Object or Attribute}
\usage{
h5_length(file, name, attr = NULL)
}
\arguments{
\item{file}{The path to the HDF5 file.}

\item{name}{The full path of the object (group or dataset).}

\item{attr}{The name of an attribute to check. If provided, the length of the attribute is returned.}
}
\value{
An integer representing the total length (number of elements).
}
\description{
Behaves like \code{length()} for R objects.
\itemize{
\item For \strong{Compound Datasets} (data.frames), this is the number of columns.
\item For \strong{Datasets} and \strong{Attributes}, this is the product of all dimensions (total number of elements).
\item For \strong{Groups}, this is the number of objects directly contained in the group.
\item Scalar datasets or attributes return 1.
}
}
\examples{
file <- tempfile(fileext = ".h5")

h5_write(1:100, file, "my_vec")
h5_length(file, "my_vec") # 100

h5_write(mtcars, file, "my_df")
h5_length(file, "my_df") # 11 (ncol(mtcars))

h5_write(as.matrix(mtcars), file, "my_mtx")
h5_length(file, "my_mtx") # 352 (prod(dim(mtcars)))

h5_length(file, "/") # 3

unlink(file)
}
