% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long_to_periods.R
\name{long_to_periods}
\alias{long_to_periods}
\title{Transform a data frame from long format to period format}
\usage{
long_to_periods(data, id, start, stop = NULL, by = NULL)
}
\arguments{
\item{data}{A data frame, or a data frame extension (e.g. a tibble).}

\item{id}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}>\cr
Column containing individual ids}

\item{start}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}>\cr
Time variable indicating the beginning of each row}

\item{stop}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}>\cr
Optional time variable indicating the end of each row. If not provided, it
will be derived from the dataset, considering that each row ends at the
beginning of the next one.}

\item{by}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}>\cr
Co-variables to consider (optional)}
}
\value{
A tibble.
}
\description{
Transform a data frame from long format to period format
}
\examples{
d <- dplyr::tibble(
  patient = c(1, 2, 3, 3, 4, 4, 4),
  begin = c(0, 0, 0, 1, 0, 36, 39),
  end = c(50, 6, 1, 16, 36, 39, 45),
  covar = c("no", "no", "no", "yes", "no", "yes", "yes")
)
d

d |> long_to_periods(id = patient, start = begin, stop = end)
d |> long_to_periods(id = patient, start = begin, stop = end, by = covar)

# If stop not provided, it is deduced.
# However, it considers that observation ends at the last start time.
d |> long_to_periods(id = patient, start = begin)
}
\seealso{
\code{\link[=periods_to_long]{periods_to_long()}}
}
\keyword{manip}
