% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-tbl_custom_summary.R
\name{proportion_summary}
\alias{proportion_summary}
\title{Summarize a proportion}
\usage{
proportion_summary(
  variable,
  value,
  weights = NULL,
  na.rm = TRUE,
  conf.level = 0.95,
  method = c("wilson", "wilson.no.correct", "wald", "wald.no.correct", "exact",
    "agresti.coull", "jeffreys")
)
}
\arguments{
\item{variable}{(\code{string})\cr
String indicating the name of the variable from which the proportion will be computed.}

\item{value}{(\code{scalar})\cr
Value (or list of values) of \code{variable} to be taken into account in the numerator.}

\item{weights}{(\code{string})\cr
Optional string indicating the name of a frequency weighting variable.
If \code{NULL}, all observations will be assumed to have a weight equal to \code{1}.}

\item{na.rm}{(scalar \code{logical})\cr
Should missing values be removed before computing the proportion? (default is \code{TRUE})}

\item{conf.level}{(scalar \code{numeric})\cr
Confidence level for the returned confidence interval.
Must be strictly greater than 0 and less than 1. Default to 0.95, which
corresponds to a 95 percent confidence interval.}

\item{method}{(\code{string})\cr
Confidence interval method. Must be one of
\code{c("wilson", "wilson.no.correct", "wald", "wald.no.correct", "exact", "agresti.coull", "jeffreys")}.
See \code{add_ci()} for details.}
}
\description{
This helper, to be used with \code{\link[=tbl_custom_summary]{tbl_custom_summary()}}, creates a function
computing a proportion and its confidence interval.
}
\details{
Computed statistics:
\itemize{
\item \code{{n}} numerator, number of observations equal to \code{values}
\item \code{{N}} denominator, number of observations
\item \code{{prop}} proportion, i.e. \code{n/N}
\item \code{{conf.low}} lower confidence interval
\item \code{{conf.high}} upper confidence interval
}

Methods \code{c("wilson", "wilson.no.correct")} are calculated with
\code{\link[stats:prop.test]{stats::prop.test()}} (with \code{correct = c(TRUE, FALSE)}). The default method,
\code{"wilson"}, includes the Yates continuity correction.
Methods \code{c("exact", "asymptotic")} are calculated with \code{Hmisc::binconf()}
and the corresponding method.
}
\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed("broom", ref = "cardx")) withAutoprint(\{ # examplesIf}
# Example 1 ----------------------------------
Titanic |>
  as.data.frame() |>
  tbl_custom_summary(
    include = c("Age", "Class"),
    by = "Sex",
    stat_fns = ~ proportion_summary("Survived", "Yes", weights = "Freq"),
    statistic = ~ "{prop}\% ({n}/{N}) [{conf.low}-{conf.high}]",
    digits = ~ list(
      prop = label_style_percent(digits = 1),
      n = 0,
      N = 0,
      conf.low = label_style_percent(),
      conf.high = label_style_percent()
    ),
    overall_row = TRUE,
    overall_row_last = TRUE
  ) |>
  bold_labels() |>
  modify_footnote_header("Proportion (\%) of survivors (n/N) [95\% CI]", columns = all_stat_cols())
\dontshow{\}) # examplesIf}
}
\author{
Joseph Larmarange
}
