% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_reg_combine.R
\name{plot_reg_combine}
\alias{plot_reg_combine}
\title{Visualize Univariate and Multivariate Regression Side-by-Side}
\usage{
plot_reg_combine(
  tbl_uni,
  tbl_multi,
  title_uni = NULL,
  title_multi = NULL,
  ref_line = 1,
  order_y = NULL,
  log_x = FALSE,
  point_color = "#1F77B4",
  errorbar_color = "#4C4C4C",
  base_size = 14,
  show_ref = TRUE,
  xlim_uni = NULL,
  breaks_uni = NULL,
  xlim_multi = NULL,
  breaks_multi = NULL
)
}
\arguments{
\item{tbl_uni}{A `gtsummary` object from `uni_reg()` etc.,}

\item{tbl_multi}{A `gtsummary` object from `multi_reg()`.}

\item{title_uni}{Optional plot title for the univariate model}

\item{title_multi}{Optional plot title for the multivariable mode}

\item{ref_line}{Numeric value for the reference line (default = 1).}

\item{order_y}{Optional character vector to manually order the y-axis labels.}

\item{log_x}{Logical. If `TRUE`, x-axis is log-transformed (default = FALSE).}

\item{point_color}{Optional color for plot points.}

\item{errorbar_color}{Optional color for error bars.}

\item{base_size}{Numeric. Base font size for plot text elements.}

\item{show_ref}{Logical. If `TRUE`, includes reference categories}

\item{xlim_uni}{Optional numeric vector to set x-axis limits for uni plot.}

\item{breaks_uni}{Optional numeric vector to set x-axis breaks for uni plot.}

\item{xlim_multi}{Optional numeric vector to set x-axis limits for multi plot}

\item{breaks_multi}{Optional numeric vector to set x-axis breaks- multi plot.}
}
\value{
A `ggplot2` object with two forest plots displayed side-by-side.
}
\description{
Generates side-by-side plots to compare univariate & multivariable results
}
\examples{
\donttest{
if (requireNamespace("mlbench", quietly = TRUE)) {
  data("PimaIndiansDiabetes2", package = "mlbench")
  library(dplyr)
  library(gtregression)

  # Prepare data
  pima <- PimaIndiansDiabetes2 |>
    mutate(
      diabetes = ifelse(diabetes == "pos", 1, 0),
      bmi_cat = cut(
        mass,
        breaks = c(-Inf, 18.5, 24.9, 29.9, Inf),
        labels = c("Underweight", "Normal", "Overweight", "Obese")
      ),
      age_cat = cut(
        age,
        breaks = c(-Inf, 29, 49, Inf),
        labels = c("Young", "Middle-aged", "Older")
      )
    )

  # Univariate logistic regression
  uni_rr <- uni_reg(
    data = pima,
    outcome = "diabetes",
    exposures = c("age_cat", "bmi_cat"),
    approach = "logit"
  )

  # Multivariable logistic regression
  multi_rr <- multi_reg(
    data = pima,
    outcome = "diabetes",
    exposures = c("age_cat", "bmi_cat"),
    approach = "logit"
  )

  # Combined plot
  plot_reg_combine(uni_rr, multi_rr)
}
}
}
