% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_weekday.R
\name{filter_by_weekday}
\alias{filter_by_weekday}
\title{Filter GTFS object by weekday}
\usage{
filter_by_weekday(gtfs, weekday, combine = "or", keep = TRUE)
}
\arguments{
\item{gtfs}{A GTFS object, as created by \code{\link[=read_gtfs]{read_gtfs()}}.}

\item{weekday}{A character vector. The weekdays used to filter the data.
Possible values are \code{c("monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday")}.}

\item{combine}{A string. Specifies which logic operation (OR or AND) should
be used to filter the calendar table when multiple weekdays are specified.
Defaults to \code{"or"}. Please check the details and examples sections for more
information on this argument usage.}

\item{keep}{A logical. Whether the entries related to the specified weekdays
should be kept or dropped (defaults to \code{TRUE}, which keeps the entries).}
}
\value{
The GTFS object passed to the \code{gtfs} parameter, after the filtering
process.
}
\description{
Filters a GTFS object by weekday, keeping (or dropping) the relevant entries
in each file.
}
\section{\code{combine} usage}{
When filtering the calendar table using weekdays, one could reason about the
process in different ways. For example, you may want to keep only services
who run on mondays AND tuesdays. Or you may want to keep services that run
EITHER on mondays OR on tuesdays. The first case is the equivalent of
filtering using the expression \code{monday == 1 & tuesday == 1}, while the second
uses \code{monday == 1 | tuesday == 1}. You can use the \code{combine} argument to
control this behaviour.

Please note that \code{combine} also works together with \code{keep}. Using the same
examples listed above, you could either keep the entries related to services
that run on mondays and tuesdays or drop them, depending on the value you
pass to \code{keep}.
}

\examples{
\dontshow{
  old_dt_threads <- data.table::setDTthreads(1)
  on.exit(data.table::setDTthreads(old_dt_threads), add = TRUE)
}
# read gtfs
data_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")
gtfs <- read_gtfs(data_path)

object.size(gtfs)

# keeps entries related to services than run EITHER on monday OR on sunday
smaller_gtfs <- filter_by_weekday(gtfs, weekday = c("monday", "sunday"))
smaller_gtfs$calendar[, c("service_id", "monday", "sunday")]
object.size(smaller_gtfs)

# keeps entries related to services than run on monday AND on sunday
smaller_gtfs <- filter_by_weekday(
  gtfs,
  weekday = c("monday", "sunday"),
  combine = "and"
)
smaller_gtfs$calendar[, c("service_id", "monday", "sunday")]
object.size(smaller_gtfs)

# drops entries related to services than run EITHER on monday OR on sunday
# the resulting gtfs shouldn't include any trips running on these days
smaller_gtfs <- filter_by_weekday(
  gtfs,
  weekday = c("monday", "sunday"),
  keep = FALSE
)
smaller_gtfs$calendar[, c("service_id", "monday", "sunday")]
object.size(smaller_gtfs)

# drops entries related to services than run on monday AND on sunday
# the resulting gtfs may include trips that run on these days, but no trips
# that run on both these days
smaller_gtfs <- filter_by_weekday(
  gtfs,
  weekday = c("monday", "sunday"),
  combine = "and",
  keep = FALSE
)
smaller_gtfs$calendar[, c("service_id", "monday", "sunday")]
object.size(smaller_gtfs)
}
\seealso{
Other filtering functions: 
\code{\link{filter_by_agency_id}()},
\code{\link{filter_by_route_id}()},
\code{\link{filter_by_route_type}()},
\code{\link{filter_by_service_id}()},
\code{\link{filter_by_sf}()},
\code{\link{filter_by_shape_id}()},
\code{\link{filter_by_spatial_extent}()},
\code{\link{filter_by_stop_id}()},
\code{\link{filter_by_time_of_day}()},
\code{\link{filter_by_trip_id}()}
}
\concept{filtering functions}
