\name{plotRecruit}
\alias{plotRecruit}
\title{A recruitment plot for a  gsearly model}
\usage{plotRecruit(mod, xlim=NA, ylim=NA, xlab=NA, ylab=NA, title=NULL, col=NA,
    lty=c(1,2), pch=3, las=1, wopcol=grey(0.9), intlab=NA, labpos=3,
    legpos="topleft", tlag=c(0,0), pcol=1, ...)}
\description{A recruitment plot for a gsearly model.}
\arguments{
 \item{mod}{A gsearly model from function \code{\link{gsearlyModel}} or
   \code{\link{gsearlyUser}} functions.}
 \item{xlim}{The \code{x} limits \code{c(x1, x2)} of the plot; default
   \code{NA}.}
 \item{ylim}{The \code{y} limits of the plot; default \code{NA}.}
 \item{xlab}{A label for the x axis; defaults to \code{"Time"}.}
 \item{ylab}{A label for the y axis; defaults to \code{"Number Recruited"}.}
 \item{title}{A main title for the plot; default \code{NULL}.}
 \item{col}{Plotting colors for the lines showing recruited numbers;
   defaults to \code{1:mod$rdata$s}.}
 \item{lty}{A vector of length 2 indicating the line types for the lines showing
   numbers recruited and the interim analyses times; default \code{c(1, 2)}.}
 \item{pch}{Plotting character or symbol for points; default 3.}
 \item{las}{A numeric value which is one of either 0, 1, 2 or 3; the style of
   axis labels, 0: always parallel to the axis, 1: always horizontal (default),
   2: always perpendicular to the axis, 3: always vertical.}
 \item{wopcol}{Color for the window of opportunity region, default
   \code{grey(0.9)}. Set to \code{grey(1)} for no color.}
 \item{intlab}{A vector of labels for the interim analyses; defaults to t[1],
   t[2], etc. Set to \code{NULL}, for no labels.}
 \item{labpos}{Position of interim labels; default 3.}
 \item{legpos}{Legend position is one of \code{"bottomright"}, \code{"bottom"},
   \code{"bottomleft"}, \code{"left"}, \code{"topleft"}, \code{"top"},
   \code{"topright"}, \code{"right"} and \code{"center"}; default
   \code{"topleft"}.}
 \item{tlag}{A vector of length 2, with positive values for time lags,
   pre-recruitment and post-recruitment, over which to extend the plotted lines;
   default \code{c(0, 0)}.}
 \item{pcol}{Color for points and interim lines; default 1.}
 \item{...}{Further arguments to plot function.}
}
\value{
 A plot of the selected type or a list consisting of the plotted line and
 interim point data and bounds for the window of opportunity.
}
\examples{

 # For 90 percent power (pow), a call to gsearlyModel provides a feasible design
 fp <- c(0.0000,0.0010,0.0250)
 tn <- c(0.4800,0.7200,0.9750)
 rctdesign <- gsearlyModel(rmodel="dilin", trecruit=36, s=3, tfu=c(3,6,12),
                   tinterims=c(16,31), pow=0.8,
                   cmodel="exponential", sd=20, rho=0.75, theta=8, fp=fp, tn=tn)
 plotRecruit(rctdesign)

}

