\name{gsearlyModel}
\alias{gsearlyModel}
\title{Model based estimates of sample size and power for group sequential
         designs with early outcomes}
\usage{gsearlyModel(rmodel="fix", trecruit, s, tfu, tinterims, pow=0.9, n=NULL,
        theta, tref=c(1,2), vphi=0.5, m=2, cmodel="uniform", sd=1, rho=0.5,
        fp, tn, treatnames=c("control", "treat"),
        sopt=list(r=18, bisect=list(min=20, max=10000, niter=1000, tol=0.001)))}
\description{Provides sample sizes and power for group sequential designs with
  early outcomes defined by a recruitment and correlation model, recruitment
  period and interim analysis time-points.}
\arguments{
 \item{rmodel}{Recruitment model, options are c(\code{"fix"}, \code{"dlin"},
  \code{"ilin"}, \code{"dquad"}, \code{"iquad"}, \code{"dilin"}, \code{"idlin"},
  \code{"diquad"}, \code{"idquad"}, \code{"filin"}, \code{"fdlin"},
  \code{"ilinf"}, \code{"dlinf"})  with default=\code{"fix"}.}
 \item{trecruit}{The recruitment period (an integer >1) which is used to define
   the base units for all analyses and plotting functions (which are on a scale
   of \code{1:trecruit}) and is usually the smallest practical study time unit;
   e.g. if \code{trecruit=30} months, then \code{tinterims} and \code{tfu}
   should also be set in units of months.}
 \item{s}{The study outcome is observed at a sequence of \code{s} occasions,
   with \code{s - 1} early outcomes. An integer value, 2 <= \code{s} <= 10, the
   upper limit is purely for reasons of practical implementation.}
 \item{tfu}{A vector of length \code{s}, of follow-up time points, in the same
   units as \code{trecruit}.}
 \item{tinterims}{A vector of ordered numeric interim analysis time-points, in
   the same units as \code{trecruit}.}
 \item{pow}{The study target power. If \code{n} is set, then this is ignored and
   the study power is reported.}
 \item{n}{The total study sample size (control + treatment groups). If this is
   set to \code{NULL} then the bisection algorithm is used to find \code{n} to
   give power \code{pow}.}
 \item{theta}{The treatment effect, in the same units as \code{sd}. Current
   implementation forces a positive value for \code{theta}.}
 \item{tref}{A vector of integers of length 2 that defines the correlation
   parameter \code{rho} for the exponential model; the parameter \code{rho} is
   the correlation between data at times \code{tfu[tref[1]]} and
   \code{tfu[tref[2]]}, with default \code{c(1,2)}; see
   \code{\link{tfuStandard}}.}
 \item{vphi}{A weight for unequal group sizes 0 < \code{vphi} < 1 where the
   ratio of control to treatment group participants is \code{vphi} / (1 -
   \code{vphi}), with default of 0.5 (equal group sizes).}
 \item{m}{A parameter (1 <= \code{m} < \code{Inf}) that sets the recruitment
   model breakpoint for those models that have two phases (e.g. \code{"diquad"}
   or \code{"dilin"}). Ignored for models that do not have two phases.}
 \item{cmodel}{The correlation model is set to either \code{"uniform"} or
   \code{"exponential"}; see \code{\link{corrExp}}, \code{\link{corrUnif}}.}
 \item{sd}{The standard deviation (0 < \code{sd} < \code{Inf}) of the outcome,
   that is assumed to be the same in both arms and at each time-point.}
 \item{rho}{The correlation parameter (0 <= \code{rho} < 1) associated with
   correlation model \code{cmodel}.}
 \item{fp}{A vector (of length \code{tinterims + 1}) of false positive rates;
   see \code{Examples}.}
 \item{tn}{A vector (of length \code{tinterims + 1}) of true negative rates;
   see \code{Examples}.}
 \item{treatnames}{Names used for the two study groups, referred to elsewhere
   as the first (or 0) and second (or 1) groups, with default
   \code{c("control","treat")}.}
 \item{sopt}{List of settings for the \code{gsBound} and \code{gsProbability}
   functions in the \code{gsDesign} package and settings for the bisection
   algorithm with default \code{list(r=18, bisect=list(min=20, max=10000,
   niter=1000, tol=0.001))}. The \code{min}, \code{max}, \code{niter} and
   \code{tol} settings represent the minimum and maximum starting points,
   maximum number of iterations and tolerance for the bisection algorithm.}
}
\value{
 An object of class gsearly is a list containing the following components.
 \item{title}{Package title and version number.}
 \item{call}{Call to \code{gsearlyModel}.}
 \item{rdata}{A list of the recruitment model (\code{rmodel}), the recruitment
   period (\code{trecruit}), the number of follow-up time-points (\code{s}), the
   follow-up time points (\code{tfu}), on the scale of \code{trecruit}
   (\code{tfu$tfu}) and on the standardized scale (\code{tfu$stfu}), the study
   sample size (\code{n}) for the control and treatment groups and the total
   (control, treat, total), the weight for the unequal group sizes
   (\code{vphi}), the recruitment model parameter (\code{m}), the interims
   analyses time-points (\code{tinterims}), in the units of \code{trecruit},
   and the numbers of study participants recruited and with outcome data at each
   of the interims (\code{interims}).}
 \item{idata}{A list of the correlation model (\code{cmodel}), consisting of the
   correlation model type (\code{cmodel$type}), parameter (\code{cmodel$rho})
   and correlation matrix (\code{cmodel$corrmat}), the standard deviation
   (\code{sd}), interim and final analysis times (\code{tinterims}) and the
   information fraction (\code{tau}) and variance of the treatment effect
   estimate (\code{vbeta}) at times \code{tinterims}.}
 \item{power}{A list of the total number of the looks (\code{nlooks}),
   treatment effect (\code{theta}), the target power (\code{setpow}), the false
   positive (\code{fp}) and true negative rates (\code{tn}), the lower
   (\code{lowerror}) and upper (\code{upperror}) boundaries and stopping
   probabilities (\code{bound}, \code{prob}) for each look and the total
   stopping probabilities (\code{totalerror}) summed across looks
   (\code{futility}, \code{efficacy}).}
}
\seealso{
 \code{\link{expectSampsize}}, \code{\link{fixedSampsize}},
 \code{\link{roundInterims}}, \code{\link{corrExp}}, \code{\link{corrUnif}}
}
\examples{

 # RCT planning:

 # Recruitment is expected to take 36 months (trecruit) with three
 # follow-up times (s) for outcomes at 3, 6 and 12 months (tfu) and
 # interim analyses (tinterims) at 18 and 30 months.
 # Study procedures and experience suggest that "dilin" (m=2) is likely
 # to be a good approximation to temporal patterns of recruitment and data
 # accrual (rmodel). Correlations between outcomes at 3, 6 and 12 are
 # assumed to follow a uniform model (cmodel) with parameter  (rho) set to 0.5.
 # Randomisation to the two study arms will be on a 1:1 basis (vphi=0.5).
 # The standard deviation of the final 12m outcome is expected to be 20,
 # and the anticipated treatment effect (theta) 8.

 # Primary interest for the RCT is in stopping early for futility.
 # Therefore the following values for the false positive and true
 # negative rates were selected.
 # Vectors of cumulative probabilities for crossing boundaries under the
 # null hypothesis (of no treatment difference).
 fp <- c(0.0000,0.0010,0.0250)
 tn <- c(0.2400,0.7200,0.9750)

 # For 90 percent power (pow), a call to gsearlyModel provides a feasible design
 rctdesign <- gsearlyModel(rmodel="dilin", trecruit=36, s=3, tfu=c(3,6,12),
                   tinterims=c(18,30), pow=0.9, vphi=0.5, m=2,
                   cmodel="uniform", sd=20, rho=0.5, theta=8, fp=fp, tn=tn)
 rctdesign

 # If n is set, rather than pow, then we can explore power for lower n
 update(rctdesign, n=136)

 # Expected numbers of participants at interim analyses
 rctdesign$rdata$interims

 # Information at these interims and final analysis
 rctdesign$idata$interims

 # Upper and lower stopping boundaries and probabilities
 rctdesign$power$lowerror
 rctdesign$power$upperror

}
