% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneSample.Estimator.sequential.R
\name{OneSample.Estimator.sequential}
\alias{OneSample.Estimator.sequential}
\title{Function to estimate the one-sample mean frequency under a group sequential design.}
\usage{
OneSample.Estimator.sequential(data, t = NULL)
}
\arguments{
\item{data}{A data frame generated by \code{Onesample.generate.sequential()} (optionally after applying \code{Apply.calendar.censoring()})
containing composite endpoint data in long format. Each subject may contribute multiple rows corresponding to recurrent events,
terminal event, or censoring.}

\item{t}{Optional numeric vector specifying event times (time since enrollment) at which the mean frequency estimator
and its variance are evaluated. Default is \code{NULL}.}
}
\value{
If \code{t} is provided, returns a list containing:
\itemize{
\item \code{muhat}: Estimated mean frequency function evaluated at \code{t}.
\item \code{varhat}: Estimated variance of \code{muhat} at \code{t}.
\item \code{n}: Sample size of the input dataset.
}
 If \code{t} is \code{NULL}, returns a numeric vector \code{xihat} giving the estimated cumulative variance component
 evaluated at all ordered observed event time. This quantity is not the mean frequency estimator itself.
 @importFrom dplyr group_by filter mutate count select slice ungroup
 @importFrom tibble as_tibble
 @importFrom bdsmatrix bdsBlock
 @importFrom rlang .data
}
\description{
Computes the nonparametric one-sample estimator of the mean frequency function for composite endpoints consisting
of recurrent events and terminal event (death), using data observed up to a given calendar time. The estimator is constructed
on the event-time scale (time since subject enrollment).
}
\examples{
df <- Onesample.generate.sequential(size = 400, recruitment = 3,
calendar = 5, random.censor.rate = 0.05, seed = 1123)
OneSample.Estimator.sequential(data= df, t = c(1.5, 2.9, 4.6))
}
