% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/job.R
\name{gsSurvCalendarTune}
\alias{gsSurvCalendarTune}
\title{Create a tune job for \code{gsDesign::gsSurvCalendar()}}
\usage{
gsSurvCalendarTune(..., upper = NULL, lower = NULL)
}
\arguments{
\item{...}{Arguments to \code{\link[gsDesign:gsSurvCalendar]{gsDesign::gsSurvCalendar()}}. Any argument can be
replaced by a \verb{tune_*()} specification.}

\item{upper, lower}{Optional spending specifications provided as
\code{SpendingSpec} or \code{SpendingFamily}. When supplied, these are translated to
the underlying \verb{(sfu, sfupar)} / \verb{(sfl, sflpar)} arguments.}
}
\value{
A \code{GSDTuneJob} R6 object.
}
\description{
\code{gsSurvCalendarTune()} is a drop-in replacement for
\code{\link[gsDesign:gsSurvCalendar]{gsDesign::gsSurvCalendar()}} that returns a tune job object instead of
immediately running a single design.
}
\details{
Any argument can be replaced by a tuning specification created by \verb{tune_*()}.
Use \code{SpendingSpec} / \code{SpendingFamily} via \verb{upper=} and \verb{lower=} for
dependency-aware spending function tuning.
}
\examples{
job <- gsSurvCalendarTune(
  calendarTime = tune_values(list(c(12, 24, 36), c(12, 24, 48))),
  spending = c("information", "calendar")
)
\donttest{
job$run(strategy = "grid", parallel = FALSE, seed = 1)
utils::head(job$results())
}
}
