% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{gr_plot_tests}
\alias{gr_plot_tests}
\title{Plot change year density}
\usage{
gr_plot_tests(tests, type = "year", print = TRUE)
}
\arguments{
\item{tests}{\code{list} of tests generated by \code{\link[=gr_test_vars]{gr_test_vars()}}.}

\item{type}{Character string type of the plot. Currently only \code{'year'} is supported, which means that the distribution density of the change year detected by Pettitt test is visualized. Ignored until other types are implemented.}

\item{print}{Boolean. Print plot? Defaults to \code{TRUE}. Use \code{FALSE} if you want to tweak the plot aesthetics before plotting.}
}
\value{
\code{ggplot2} object representing the selected type of the tested variable
}
\description{
The function extracts change years from results of \code{\link[=gr_test_vars]{gr_test_vars()}} and plots their probability density. Since for every variable the change year is individual, this procedure allows finding the one most probable year, which is the mode of the distribution. This year is highlighted by the line and labeled on the plot.
}
\examples{
library(grwat)

data(spas) # example Spas-Zagorye data is included with grwat package

# separate
sep = gr_separate(spas, params = gr_get_params(reg = 'center'))

# summarize from 1965 to 1990
vars = gr_summarize(sep, 1965, 1990)

# test all variables
tests = gr_test_vars(vars)

# plot change year from Pettitt test
gr_plot_tests(tests, type = 'year')
}
