% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{calc_bai}
\alias{calc_bai}
\title{calculate annual basal area increment}
\usage{
calc_bai(data)
}
\arguments{
\item{data}{data in long format containing at least 3 columns: id, year, rw}
}
\value{
add 3 columns to the original input data, ageC for cambial age, ba_cm2_t_1 for basal area of the previous year in cm2, and bai_cm2 for annual basal area increment in cm2
}
\description{
calculate basal area (cm2) and basal area increment (cm2)
}
\examples{
 # generate data
dt.rw <- data.table::data.table(
  uid_radius = rep(paste0("R", 1:3), each = 5),
  year      = rep(2001:2005, times = 3),
  rw_mm     = round(runif(15, 0.5, 3.5),2)
)
data.table::setorder(dt.rw, uid_radius, year)
 # calculate bai
dt.rw <- calc_bai(dt.rw)

}
