% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rppp.R
\name{.rppp}
\alias{.rppp}
\title{Simulate (Marked) Point Pattern}
\usage{
.rppp(
  ...,
  dots,
  win = square(),
  n = 1L,
  element1 = TRUE,
  envir = parent.frame()
)
}
\arguments{
\item{...}{see vignettes}

\item{dots}{(for internal use) \link[base]{list} of one or more named \link[base]{list}s.
The first \link[base]{list} specifies the parameters to
generate the \eqn{x}- and \eqn{y}-\link[spatstat.geom]{coords}.
The second to last \link[base]{list}s, if available, specify the parameters to
generate one or more \link[spatstat.geom]{marks}.}

\item{win}{\link[spatstat.geom]{owin.object}}

\item{n}{\link[base]{integer} scalar,
number of \link[spatstat.geom]{ppp.object}s to generate.
Default \code{1L}.}

\item{element1}{\link[base]{logical} scalar, whether to return
a \link[spatstat.geom]{ppp.object},
instead of a \link[base]{length}-\code{1L} \link[spatstat.geom]{solist},
when \code{n==1L}. Default \code{TRUE}}

\item{envir}{\link[base]{environment}, in which to \link[base]{eval}uate the \code{...} \link[rlang]{dyn-dots} argument.
Default is the \link[base]{parent.frame}.}
}
\value{
Function \code{\link[=.rppp]{.rppp()}} returns a \link[spatstat.geom]{ppp.object} if \code{(n==1L)&element1},
otherwise returns a \link[base]{length}-\code{n} \link[spatstat.geom]{solist}
(which also has \link[base]{class} \code{'ppplist'}).

The returned \link[spatstat.geom]{ppp.object}(s) contain only
\eqn{x}- and \eqn{y}-\link[spatstat.geom]{coords},
if only one \link[base]{call} is present in the \code{...} \link[rlang]{dyn-dots} argument.
Otherwise, they contain one or more \link[spatstat.geom]{marks}
according to the rest of the \link[base]{call}(s) in the \code{...} argument.
}
\description{
To generate \link[spatstat.geom]{ppp.object}(s),
with none or one or multiple \link[spatstat.geom]{marks}.
}
\note{
The name \code{rppp()} is too aggressive, which might be claimed in future by package \CRANpkg{spatstat.random}.
Therefore we name this function \code{\link[=.rppp]{.rppp()}} as if it is hidden (see parameter \code{all.names} of function \link[base]{ls}).
}
\keyword{internal}
