% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{on_startup}
\alias{on_startup}
\title{Function to Handle Package Startup Logic}
\usage{
on_startup(uiStartup = uiInit, serverStartup = serverInit)
}
\arguments{
\item{uiStartup}{Shiny user interface.}

\item{serverStartup}{Shiny server.}
}
\value{
None
}
\description{
The \code{on_startup} function is designed to execute certain actions when the package is loaded.
Specifically, it checks for the presence of required environment variables related to the GROQ system.
If any of these variables are missing, it will launch a Shiny application.
}
\details{
The function checks the following environment variables:
\itemize{
\item \code{GROQ_model}
\item \code{GROQ_systemRole}
\item \code{GROQ_API_KEY}
\item \code{GROQ_maxTokens}
\item \code{GROQ_temperature}
\item \code{GROQ_top_p}
\item \code{GROQ_proxy}
}

If any of these variables are not set (i.e., are empty strings), the function triggers the
launch of a Shiny application defined by the \code{ui} and \code{server} components.
}
\seealso{
\code{shinyApp}
}
