% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grmtree.R
\name{grmfit}
\alias{grmfit}
\title{Internal Function: Fit Graded Response Model}
\usage{
grmfit(
  y,
  x = NULL,
  start = NULL,
  weights = NULL,
  offset = NULL,
  ...,
  estfun = FALSE,
  object = FALSE
)
}
\arguments{
\item{y}{A matrix of item responses (rows = persons, columns = items)}

\item{x}{Optional predictor matrix (not currently used)}

\item{start}{Optional starting values (passed to mirt)}

\item{weights}{Optional case weights (not currently used)}

\item{offset}{Optional offset (not currently used)}

\item{...}{Additional arguments passed to \code{mirt::mirt}}

\item{estfun}{Logical indicating whether to compute empirical estimating
functions}

\item{object}{Logical indicating whether to return the full mirt model object}
}
\value{
A list containing: \item{coefficients}{Item parameter estimates}
\item{objfun}{Negative log-likelihood value} \item{estfun}{Empirical
estimating functions if requested} \item{object}{Full mirt model object if
requested}
}
\description{
Fits a graded response model (GRM) to item response data. This is an internal
function called by \code{grmtree} and is not intended to be used directly.
}
\keyword{internal}
