% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grep_read.r
\name{grep_read}
\alias{grep_read}
\title{grep_read: Efficiently read and filter lines from one or more files using grep,
returning a data.table.}
\usage{
grep_read(
  files = NULL,
  path = NULL,
  file_pattern = NULL,
  pattern = "",
  invert = FALSE,
  ignore_case = FALSE,
  fixed = FALSE,
  show_cmd = FALSE,
  recursive = FALSE,
  word_match = FALSE,
  show_line_numbers = FALSE,
  only_matching = FALSE,
  nrows = Inf,
  skip = 0,
  header = TRUE,
  col.names = NULL,
  include_filename = FALSE,
  show_progress = FALSE,
  ...
)
}
\arguments{
\item{files}{Character vector of file paths to read.}

\item{path}{Optional. Directory path to search for files.}

\item{file_pattern}{Optional. A pattern to filter filenames when using the
\code{path} argument. Passed to \code{list.files}.}

\item{pattern}{Pattern to search for within files (passed to grep).}

\item{invert}{Logical; if TRUE, return non-matching lines.}

\item{ignore_case}{Logical; if TRUE, perform case-insensitive matching (default: TRUE).}

\item{fixed}{Logical; if TRUE, pattern is a fixed string, not a regular
expression.}

\item{show_cmd}{Logical; if TRUE, return the grep command string instead of
executing it.}

\item{recursive}{Logical; if TRUE, search recursively through directories.}

\item{word_match}{Logical; if TRUE, match only whole words.}

\item{show_line_numbers}{Logical; if TRUE, include line numbers from source
files. Headers are automatically removed and lines renumbered.}

\item{only_matching}{Logical; if TRUE, return only the matching part of the
lines.}

\item{nrows}{Integer; maximum number of rows to read.}

\item{skip}{Integer; number of rows to skip.}

\item{header}{Logical; if TRUE, treat first row as header.  Note that using FALSE means that the first row will be included as a row of data in the reading process.}

\item{col.names}{Character vector of column names.}

\item{include_filename}{Logical; if TRUE, include source filename as a column.}

\item{show_progress}{Logical; if TRUE, show progress indicators.}

\item{...}{Additional arguments passed to fread.}
}
\value{
A data.table with different structures based on the options:
\itemize{
\item Default: Data columns with original types preserved
\item show_line_numbers=TRUE: Additional 'line_number' column (integer) with source file line numbers
\item include_filename=TRUE: Additional 'source_file' column (character)
\item only_matching=TRUE: Single 'match' column with matched substrings
\item show_cmd=TRUE: Character string containing the grep command
}
}
\description{
grep_read: Efficiently read and filter lines from one or more files using grep,
returning a data.table.
}
\note{
When searching for literal strings (not regex patterns), set
\code{fixed = TRUE} to avoid regex interpretation. For example, searching for
"3.94" with \code{fixed = FALSE} will match "3894" because "." is a regex
metacharacter.

Header rows are automatically handled:
\itemize{
\item With show_line_numbers=TRUE: Headers (line_number=1) are removed and
lines renumbered
\item Without line numbers: Headers matching column names are removed
\item Empty rows and all-NA rows are automatically filtered out
}
}
