% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grep_count.r
\name{grep_count}
\alias{grep_count}
\title{grep_count: Efficiently count the number of relevant records from one or more files using grep}
\usage{
grep_count(
  files = NULL,
  path = NULL,
  file_pattern = NULL,
  pattern = "",
  invert = FALSE,
  ignore_case = FALSE,
  fixed = FALSE,
  recursive = FALSE,
  word_match = FALSE,
  only_matching = FALSE,
  skip = 0,
  header = TRUE,
  include_filename = FALSE,
  show_cmd = FALSE,
  show_progress = FALSE,
  ...
)
}
\arguments{
\item{files}{Character vector of file paths to read.}

\item{path}{Optional. Directory path to search for files.}

\item{file_pattern}{Optional. A pattern to filter filenames when using the
\code{path} argument. Passed to \code{list.files}.}

\item{pattern}{Pattern to search for within files (passed to grep).}

\item{invert}{Logical; if TRUE, return non-matching lines.}

\item{ignore_case}{Logical; if TRUE, perform case-insensitive matching (default: TRUE).}

\item{fixed}{Logical; if TRUE, pattern is a fixed string, not a regular
expression.}

\item{recursive}{Logical; if TRUE, search recursively through directories.}

\item{word_match}{Logical; if TRUE, match only whole words.}

\item{only_matching}{Logical; if TRUE, return only the matching part of the
lines.}

\item{skip}{Integer; number of rows to skip.}

\item{header}{Logical; if TRUE, treat first row as header.}

\item{include_filename}{Logical; if TRUE, include source filename as a column.}

\item{show_cmd}{Logical; if TRUE, return the grep command string instead of
executing it.}

\item{show_progress}{Logical; if TRUE, show progress indicators.}

\item{...}{Additional arguments passed to fread.}
}
\value{
A data.table containing file names and counts.
}
\description{
grep_count: Efficiently count the number of relevant records from one or more files using grep
}
