% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{sample_values}
\alias{sample_values}
\title{Sample greenspace-realted data from Greenspace Seasonality Data Cube,
ESA WorldCover 10m Annual Composites Dataset, or Sentinel-2-l2a images.}
\usage{
sample_values(
  samples = NULL,
  time = NULL,
  source = "gsdc",
  output_bands = NULL,
  cloud_cover = 10,
  vege_perc = 0,
  select = "latest",
  method = "first",
  quiet = TRUE
)
}
\arguments{
\item{samples}{A list, matrix, \code{data.frame}, or \code{sf} object of point locations.
Can be a list of length-2 numeric vectors (\code{list(c(lon, lat))}),
a 2-column matrix or data.frame, or an \code{sf} object with POINT geometry in any CRS.}

\item{time}{numeric or vector. The time of interest. See Detail.}

\item{source}{character. The data source for extracting greenspace values:
\code{gsdc} for Greenspace Seasonality Data Cube (also see \code{\link[=get_gsdc]{get_gsdc()}}]),
\code{esa_ndvi}or \code{esa_landcover} for ESA WorldCover 10m Annual Dataset
(also see \code{\link[=get_esa_wc]{get_esa_wc()}}]), and \code{s2a_ndvi} or \code{s2a_bands} for
Sentinel-2-l2a image data (also see \code{\link[=get_s2a_ndvi]{get_s2a_ndvi()}}]). The default is \code{gsdc}.}

\item{output_bands}{vector. A list of band names (\code{c('B04', 'B08')}).
The default is \code{NULL}. (Only required, when \code{source = "s2a_bands"})
All available bands can be found \href{https://docs.sentinel-hub.com/api/latest/data/sentinel-2-l2a/#available-bands-and-data}{here}}

\item{cloud_cover}{numeric. The percentage of cloud coverage for retrieving
Sentinel-2-l2a images. (Only required, when \code{source = "s2a_ndvi"} or \code{source = "s2a_bands"})}

\item{vege_perc}{numeric. The percentage of cloud coverage for retrieving
Sentinel-2-l2a images. (Only required, when \code{source = "s2a_ndvi"} or \code{source = "s2a_bands"})}

\item{select}{character. one of "latest", "earliest", "all". The default
is "latest".}

\item{method}{character. A method for mosaicing layers: one of "mean",
"median", "min", "max", "modal", "sum", "first", "last". The default
is "first".}

\item{quiet}{logical. Whether show progress bars for some process.}
}
\value{
A \code{data.frame} containing greenspace values extracted at each point
across all bands. Each row corresponds to a sample location;
columns represent band values.
}
\description{
Samples values by locatoins from the Greenspace Seasonality Data Cube
developed by Wu et al. (2024), ESA WorldCover 10m Annual Composites Dataset
by Zanaga et al. (2021), or Sentinel-2-l2a images.
}
\details{
\code{time}: For the greenspace seasonality data cube, only years from 2019 to 2022
are availabe. For ESA WorldCover 10m Annual Composites Dataset, only 2020
and 2021 are available.
}
\note{
For sampling data from Greenspace Seasonality Data Cube \code{samples} must be
located within the same boundary of an available city in the data cube.
Use \code{\link[=check_available_urban]{check_available_urban()}} and \code{\link[=check_urban_boundary]{check_urban_boundary()}} to see supported
cities and their boundaries.
}
\examples{
# see supported urban areas and their boundaries
check_available_urban()
boundary <- check_urban_boundary(uid = 11)

# sample locations with in the boundary
samples <- sf::st_sample(boundary, size = 20)

# extract values
gs_samples <- sample_values(samples,
                            # time = 2022
                           )

}
\references{
Wu, S., Song, Y., An, J. et al. High-resolution greenspace dynamic
data cube from Sentinel-2 satellites over 1028 global major cities.
Sci Data 11, 909 (2024). https://doi.org/10.1038/s41597-024-03746-7

Zanaga, D., Van De Kerchove, R., De Keersmaecker, W., Souverijns, N.,
Brockmann, C., Quast, R., Wevers, J., Grosu, A., Paccini, A., Vergnaud, S.,
Cartus, O., Santoro, M., Fritz, S., Georgieva, I., Lesiv, M., Carter, S.,
Herold, M., Li, L., Tsendbazar, N.-E., … Arino, O. (2021).
ESA WorldCover 10 m 2020 v100 (Version v100).
Zenodo. https://doi.org/10.5281/zenodo.5571936

Zanaga, D., Van De Kerchove, R., Daems, D., De Keersmaecker, W., Brockmann,
C., Kirches, G., Wevers, J., Cartus, O., Santoro, M., Fritz, S., Lesiv, M.,
Herold, M., Tsendbazar, N.-E., Xu, P., Ramoino, F., & Arino, O. (2022).
ESA WorldCover 10 m 2021 v200 (Version v200).
Zenodo. https://doi.org/10.5281/zenodo.7254221
}
