% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools_generator.R
\name{rmreg}
\alias{rmreg}
\title{Generate data from a mixture of regression model}
\usage{
rmreg(
  N,
  pi,
  A,
  sigma,
  X = cbind(rep(1, N), matrix(stats::rnorm(N * (ncol(A) - 1)), N, ncol(A) - 1))
)
}
\arguments{
\item{N}{A numeric value the size of the graph to generate}

\item{pi}{A numeric vector of length K with clusters proportions (must sum up to 1)}

\item{A}{A numeric matrix of dim K x d with the regression coefficient}

\item{sigma}{A numeric of length 1 with the target conditional variance}

\item{X}{A matrix of covariate}
}
\value{
A list with fields:
\itemize{
\item X: the covariate matrix
\item y: the target feature
\item K: number of generated clusters
\item N: sample size
\item cl: vector of clusters labels
\item pi: clusters proportions
\item A: regression coefficients used in the simulation
\item sigma: conditional variance
}
}
\description{
\code{rmreg} returns an X matrix, a y vector and the cluster labels generated randomly with a Mixture of regression model.
}
\details{
It takes the sample size, cluster proportions and regression parameters matrix and variance  as input accordingly
}
