% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools_generator.R
\name{rdcsbm}
\alias{rdcsbm}
\title{Generates graph adjacency matrix using a degree corrected SBM}
\usage{
rdcsbm(N, pi, mu, betain, betaout)
}
\arguments{
\item{N}{A numeric value the size of the graph to generate}

\item{pi}{A numeric vector of length K with clusters proportions. Must sum up to 1.}

\item{mu}{A numeric matrix of dim K x K with the connectivity pattern to generate, elements in [0,1].}

\item{betain}{A numeric vector of length N which specify the in-degree correction will be normalized per cluster during the generation.}

\item{betaout}{A numeric vector of length N which specify the out-degree correction will be normalized per cluster during the generation.}
}
\value{
A list with fields:
\itemize{
\item x: the count matrix as a \code{dgCMatrix}
\item K: number of generated clusters
\item N: number of vertex
\item cl: vector of clusters labels
\item pi: clusters proportions
\item mu: connectivity matrix
\item betain: normalized in-degree parameters
\item betaout: normalized out-degree parameters
}
}
\description{
\code{rdcsbm} returns an adjacency matrix and the cluster labels generated randomly using a Degree Corrected Stochastic Block Model.
}
\details{
It takes the sample size, cluster proportions and emission matrix, and   as input and sample a graph accordingly together with the clusters labels.
}
