% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.penderiv.R
\name{plot.penderiv}
\alias{plot.penderiv}
\title{Plot Function for S3 Class "penderiv"}
\usage{
\method{plot}{penderiv}(x, ...)
}
\arguments{
\item{x}{An object inheriting from S3 class \code{"penderiv"}, typically
returned by \code{\link[grasps]{compute_penalty}}, or
\code{\link[grasps]{compute_derivative}}.}

\item{...}{Optional arguments passed to \code{\link[ggforce]{facet_zoom}}
to zoom in on a subset of the data, while keeping the view of the full
dataset as a separate panel.}
}
\value{
An object of class \code{ggplot}.
}
\description{
Generate a visualization of penalty functions produced by
\code{\link[grasps]{compute_penalty}}, or penalty derivatives produced by
\code{\link[grasps]{compute_derivative}}.
The plot automatically summarizes multiple configurations of penalty type,
\eqn{\lambda}, and \eqn{\gamma}. Optional zooming is supported through
\code{\link[ggforce]{facet_zoom}}.
}
\examples{
library(grasps)
library(ggplot2)

pen_df <- compute_penalty(
  omega = seq(-4, 4, by = 0.01),
  penalty = c("atan", "exp", "lasso", "lq", "lsp", "mcp", "scad"),
  lambda = 1)

plot(pen_df, xlim = c(-1, 1), ylim = c(0, 1), zoom.size = 1) +
  guides(color = guide_legend(nrow = 2, byrow = TRUE))

deriv_df <- compute_derivative(
  omega = seq(0, 4, by = 0.01),
  penalty = c("atan", "exp", "lasso", "lq", "lsp", "mcp", "scad"),
  lambda = 1)

plot(deriv_df) +
  scale_y_continuous(limits = c(0, 1.5)) +
  guides(color = guide_legend(nrow = 2, byrow = TRUE))
}
