% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grand.R
\name{grand}
\alias{grand}
\title{Applies Guidelines for Reporting About Network Data}
\usage{
grand(G, mode, help = FALSE, verbose = FALSE)
}
\arguments{
\item{G}{An \link[igraph]{igraph} object, with weights/signs (if present) stored in \code{E(G)$weight}}

\item{mode}{string: "interview" to interactively add information, or "statement" to generate a summary statement}

\item{help}{boolean: Should interview prompts be accompanied by explanations and examples?}

\item{verbose}{boolean: Should an extended summary be generated?}
}
\value{
An \link[igraph]{igraph} object if \code{mode == "interview"}, or a string if \code{mode == "statement"}
}
\description{
The \code{grand} function interactively adds information about a network and generates a narrative summary of the
network following the Guidelines for Reporting About Network Data.
}
\examples{
G <- igraph::make_graph("Zachary")  #An example network

#G <- grand(G, mode = "interview")  #Interactively enter information...

G <- grand_manual(G,  #...or manually enter information
     name = "Zachary Karate Club",
     doi = "10.1086/jar.33.4.3629752",
     url = "https://networks.skewed.de/net/karate",
     vertex1 = "People",
     positive = "Friendship",
     mode = "Observation",
     year = "1977")

grand(G, mode = "statement")  #Display summary statement

}
