% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{util_haplo}
\alias{util_haplo}
\title{Util fuunction to generate haplotype dataframe from raw data.}
\usage{
util_haplo(in_df, target, non_target, hetero, line_cul)
}
\arguments{
\item{in_df}{Data frame of raw data.}

\item{target}{Character of genotype which is the target of gene pyramiding.}

\item{non_target}{Character of genotype which is not the target of gene pyramiding.}

\item{hetero}{Character of genotype of heterozygote.}

\item{line_cul}{Column name containing line identifiers.}
}
\value{
A list of genotype and line names for downstream analysis. This is a list with the following components:
* `gene_df1` (`data frame`): One set of haplotype. Values take 1 (target allele) or 0 (non-target).
* `gene_df2` (`data frame`): The other set of haplotype. Values take 1 or 0.
* `line_id` (`vector`): Line names.
}
\description{
Util fuunction to generate haplotype dataframe from raw data.
}
\examples{
in_df <- data.frame(line = c("CV1", "CV2", "CV3", "CV4", "CV5"),
                    gene1 = c("A", "A", "B", "B", "A"),
                    gene2 = c("B", "A", "A", "B", "H"),
                    gene3 = c("A", "A", "H", "H", "A"),
                    gene4 = c("A", "B", "H", "A", "B"))

util_haplo(in_df, target = "A", non_target = "B", hetero = "H", line_cul = "line")

}
