% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpkg-features.R
\name{gpkg_create_empty_features}
\alias{gpkg_create_empty_features}
\title{Create an empty feature table}
\usage{
gpkg_create_empty_features(
  x,
  table_name,
  column_name = "geom",
  geometry_type_name = "GEOMETRY",
  srs_id = 4326,
  z = 0L,
  m = 0L,
  contents = TRUE,
  description = "",
  ext = c(-180, -90, 180, 90)
)
}
\arguments{
\item{x}{A \code{geopackage} Object}

\item{table_name}{\emph{character}. New table name.}

\item{column_name}{\emph{character}. Geometry column name. Default \code{"geom"}}

\item{geometry_type_name}{\emph{character}. Geometry type name. Default: \code{"GEOMETRY"}}

\item{srs_id}{\emph{integer}. Spatial Reference System ID. Must be defined in \code{gpkg_spatial_ref_sys} table.}

\item{z}{\emph{integer}. Default: \code{0}}

\item{m}{\emph{integer}. Default: \code{0}}

\item{contents}{\emph{logical}. If \code{TRUE} (default) add the new table to \code{gpkg_contents} table.}

\item{description}{\emph{character}. Description for \code{gpkg_contents} table. Default: \code{""}}

\item{ext}{\emph{numeric}. A numeric vector of length four specifying the bounding box extent.}
}
\value{
\emph{integer} result of \code{gpkg_execute()}. Returns \code{1} if a new geometry record is appended to \code{gpkg_geometry_columns} table.
}
\description{
Create an empty feature table and associated entries for \code{gpkg_spatial_ref_sys}, and \code{gpkg_geometry_columns}.
}
\seealso{
\code{\link[=gpkg_create_empty_grid]{gpkg_create_empty_grid()}}
}
